#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string>
using namespace std;
#include "../Node.hpp"
#include "../projection.hpp"

int main( int argc, char **argv)
{
   char plane = -1;
   int lod = -1;
   string extension = "bak";
   string base_path;
   
   /* Process parameters */

   for(int a=1;a<argc;a++) 
     {
	if ( strcmp( argv[a], "--help") == 0 ) 
	  {
	     fprintf( stdout, "usage: %s [options]\n\n", argv[0]) ;
	     fprintf( stdout, "options are:\n") ;
	     fprintf( stdout, "  --help               Display this help notice\n") ;
	     fprintf( stdout, "  --lod <lod>          Lod to remove\n") ;
	     fprintf( stdout, "  --plane <id>         Select plane to build: N|S|F|B|E|W\n");
	     fprintf( stdout, "  --ext <ext>          Extension of files to remove\n");
	     fprintf( stdout, "  --path <base_path>   Set the base path\n");
	     
	     return EXIT_FAILURE;
	  }
	else if ( strcmp( argv[a], "--lod") == 0 )
	  {
	     if ( a+1 < argc )
	       {
		  lod = atol( argv[++a]);
	       }
	     else
	       {
		  fprintf( stderr, "--lod must be followed by an integer\n");
		  return EXIT_FAILURE;
	       }
	  }
	else if ( strcmp( argv[a], "--plane") == 0 )
	  {
	     if ( a+1 < argc )
	       {
		  plane = argv[++a][0];
	       }
	     else
	       {
		  fprintf( stderr, "--plane must take a plane id\n");
		  return EXIT_FAILURE;
	       }
	  }	
	else if ( strcmp( argv[a], "--ext") == 0 )
	  {
	     if ( a+1 < argc )
	       {
		  extension = argv[++a];
	       }
	     else
	       {
		  fprintf( stderr, "--ext must take a file extension\n");
		  return EXIT_FAILURE;
	       }  
	  }
	else if ( strcmp( argv[a], "--path") == 0 )
	  {
	     if ( a+1 < argc )
	       {
		  base_path = argv[++a];
	       }
	     else
	       {
		  fprintf( stderr, "--path must take a path\n");
		  return EXIT_FAILURE;
	       }  
	  }

     }
   
   if ( plane == -1 || lod == -1)
     { 
	fprintf( stderr, "%s: lod and plane must be given\n");
	exit( EXIT_FAILURE);
     }
   
   Cube::Face face;
   
   switch( plane)
     {
      case 'F':
	face = Cube::Front;
	break;
      case 'E':
	face = Cube::East;
	break;
      case 'B':
	face = Cube::Back;
	break;
      case 'W':
	face = Cube::West;
	break;
      case 'N':
	face = Cube::North;
	break;
      case 'S':
	face = Cube::South;
	break;
      default: 
	fprintf( stderr, "%s: unknown face %c\n", argv[0], plane);
	exit( EXIT_FAILURE);
     }

     
   int base_width = 1 << lod;
   
   fprintf( stderr, "Will remove (%dx%d) node of the quadtree (level %d)\n", base_width, base_width, lod);
      
   for(unsigned int gy=0;gy<base_width;gy++)
     for(unsigned int gx=0;gx<base_width;gx++)
       {
	  char filename[128];
	  Node node = Node( lod, gx, base_width-1-gy, face);
	  	 
	  sprintf( filename, "%s/%c/%04d.%s", base_path.c_str(), plane, node.GetNumber(), extension.c_str());
	  
	  fprintf( stderr, "remove %s\n", filename);
	  unlink( filename);
	  
	  fprintf( stdout, "\r%4d / %4d removed   ", gy*base_width+gx, base_width*base_width); 
	  fflush( stdout);
       }   
}



