#ifndef _RAWIMAGE_HPP
#define _RAWIMAGE_HPP

#include <stdio.h>

class RawImage
{
 public:

   RawImage();
   ~RawImage();

   enum Composant
     {
	R=0,
	G=1,
	B=2,
     };
   
   void OpenFile( const char *filename, unsigned int width, unsigned int height);
   void CloseFile();
   
   void Map();
   void UnMap();
   
   unsigned char GetPixelComp( unsigned int x, unsigned int y, Composant comp);
   
 private:
   // Infos
   char *filename;
   unsigned int image_width;
   unsigned int image_height;
   bool image_ready;
   bool file_mapped;
   FILE *f;
   unsigned char *data;
};

#endif /* _RAWIMAGE_HPP */
