#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
//#define _POSIX_MAPPED_FILES
#include <sys/mman.h>
#include <string.h>
#include "rawimage.hpp"

RawImage::RawImage()
{
   filename = NULL;
   image_ready = false;
   file_mapped = false;
}

RawImage::~RawImage()
{
   CloseFile(); 
}
   


/*unsigned int RawImage::GetPixel( double lon, double lat)
{
   if ( image_ready)
     {
#ifdef BILINEAR
	unsigned int x1 = (unsigned int)(( lon - zone.GetRootLongitude() ) / zone.GetLongitudeWidth() * (double)image_width); 
	unsigned int y1 = (unsigned int)(( lat - zone.GetRootLatitude() ) / zone.GetLatitudeWidth() * (double)image_height); 
	unsigned int x2 = (unsigned int)(( lon - zone.GetRootLongitude() ) / zone.GetLongitudeWidth() * (double)image_width); 
	unsigned int y2 = (unsigned int)(( lat - zone.GetRootLatitude() ) / zone.GetLatitudeWidth() * (double)image_height); 
	unsigned int x3 = (unsigned int)(( lon - zone.GetRootLongitude() ) / zone.GetLongitudeWidth() * (double)image_width); 
	unsigned int y3 = (unsigned int)(( lat - zone.GetRootLatitude() ) / zone.GetLatitudeWidth() * (double)image_height); 
	unsigned int x4 = (unsigned int)(( lon - zone.GetRootLongitude() ) / zone.GetLongitudeWidth() * (double)image_width); 
	unsigned int y4 = (unsigned int)(( lat - zone.GetRootLatitude() ) / zone.GetLatitudeWidth() * (double)image_height); 
	double ax = 0.;
	double ay = 0.;
	
	return ax * image[]...;

#else // plus proche voisin
		     
	unsigned int x = (unsigned int)(( lon - zone.GetRootLongitude() ) / zone.GetLongitudeWidth() * (double)image_width); 
	unsigned int y = (unsigned int)(( lat - zone.GetRootLatitude() ) / zone.GetLatitudeWidth() * (double)image_height); 
	
	//fprintf( stderr, "get_pixel %d %d\n", x, y);
	return image[y*image_width+x];
#endif
     }
   else
     return 0;
}*/

void RawImage::OpenFile( const char *filename, unsigned int width, unsigned int height)
{
   image_width = width;
   image_height = height;
      
   f = fopen( filename, "r");

   if ( f == NULL )
     {
	fprintf( stderr, "Can(t open %s for reading\n", filename);
	return;
     }
   else
     image_ready = true;
}

void RawImage::CloseFile()
{
   if ( file_mapped)
     UnMap();
   
   if ( image_ready)
     fclose( f);
}

void RawImage::Map()
{
   if ( file_mapped)
     return;
   
   size_t data_length = image_width * image_height * 3;
   off_t offset = 0;
   
   data = (unsigned char *) mmap( NULL, data_length, PROT_READ, MAP_SHARED, fileno( f), offset);
   
   if ( data == (unsigned char *)-1 )
     fprintf( stderr, "RawImage: map error: %d %s\n", errno, strerror( errno));
   else
     file_mapped = true;
}

void RawImage::UnMap()
{
   if ( file_mapped)
     {
	size_t data_length = image_width * image_height * 3;
	munmap( data, data_length);
	file_mapped = false;
     }
   
}


/*void RawImage::UnloadImage()
{
   if ( image_allocated)
     {
	image_allocated = false;
	image_ready = false;
	delete []image;
     }
}*/

unsigned char RawImage::GetPixelComp( unsigned int x, unsigned y, Composant comp)
{
   if ( image_ready)
     {
	//fprintf( stderr, "get_pixel %d %d\n", x, y);
	
	if ( file_mapped)
	  {
	     return data[(y*image_width+x)*3+comp];
	  }
	else
	  {
	     off_t offset = (y*image_width+x)*3+comp;
	     if ( fseeko( f, offset, SEEK_SET))
	       {
		  fprintf( stderr, "RawImage: can't seek %dx%dx%d in file %s\n", x, y, comp, errno, strerror( errno));
		  return 0;
	       }
	     unsigned char val;
	     fread( &val, 1, 1, f);
	     return val;
	  }
     }
   else
     return 0;
}
