#include <string>
#include <fstream>
#include <iostream>
#include <SDL.h>
#include "../VectInfos.hpp"

using namespace std;

void save_collection( char *file, VectInfoCollection *collection)
{
   SDL_RWops *w_ops = SDL_RWFromFile( file, "wb");
   
   if ( w_ops == NULL)
     {
	cerr << "Can't save to " << file << endl;
     }
   else
     {
	collection->SaveBinary( w_ops);
	SDL_RWclose( w_ops);
     }
}

void load_vectinfo_binary( char *file, VectInfo *vi)
{
   SDL_RWops *r_ops = SDL_RWFromFile( file, "rb");
   
   if ( r_ops == NULL)
     {
	cerr << "Can't open " << file << endl;
     }
   else
     {
	
	try
	  {
	     vi->LoadBinary( r_ops);
	  }
	catch( string str)
	  {
	     cerr << str << endl;
	     exit( EXIT_FAILURE);
	  }
	
	SDL_RWclose( r_ops);
	
     }
}

		     
int main( int argc, char **argv)
{
   bool load_binary = true;
   
   if ( argc < 3 )
     {
	cerr << "usage: " << argv[0] << " <output_file.vnf> < -- | input files ... >" << endl;
	cerr << "       " << argv[0] << " <prefix> < --range firt_node last_node> <output extension> <input extensions>" << endl; 
	exit( EXIT_FAILURE);
     }

   if ( string(argv[2]) == string("--") ) // read input files from standard input
     {
	VectInfoCollection collection;

	while( 1)
	  {
	     VectInfo *vi = new VectInfo();  
	     string cmd;
	     cin >> cmd;
	     
	     if ( cmd == "end" )
	       break;
	     
	     if ( load_binary)
	       {
		  load_vectinfo_binary( (char *)cmd.c_str(),  vi);
	       }
	     else
	       {
		  ifstream i_file;
		  i_file.open( cmd.c_str());
		  vi->LoadASCII( &i_file);
		  i_file.close();
	       }
	     
	     collection.AddVectInfo( vi);
	  }
	  
	save_collection( argv[1], &collection);
     
     }
   else if ( string(argv[2]) == string("--range")) // read a range of files
     { 
	if ( argc < 7 )
	  {
	     cerr << "--range option must take first_node and last_node" << endl;
	     exit( EXIT_FAILURE);
	  }
	unsigned int first_node = atoi( argv[3]);
	unsigned int last_node = atoi( argv[4]);
	
	for( unsigned int n = first_node ; n <= last_node ; n++ )
	  {
	     VectInfoCollection collection;

	     for( unsigned int a = 6 ; a < argc ; a++)
	       {
		  VectInfo *vi = new  VectInfo();
		  char filename[1024];
		  sprintf( filename, "%s/%04d.%s", argv[1], n, argv[a]);
		  load_vectinfo_binary( filename, vi);
		  collection.AddVectInfo( vi);
	       }
	     
	     char f_out[1024];
	     sprintf( f_out, "%s/%04d.%s", argv[1], n, argv[5]);
	     save_collection( f_out, &collection);

	  }
     }
   else // read input files from parameters
     {
	VectInfoCollection collection;

	for( int a = 2 ; a < argc ; a++ ) 
	  {
	     VectInfo *vi = new VectInfo();
	     
	     if ( load_binary)
	       {
		  load_vectinfo_binary( argv[a], vi);
	       }
	     else
	       {
		  ifstream i_file;
		  i_file.open( argv[a]);
		//  vi.LoadASCII( &i_file);
		  i_file.close();
	       }
	     
	     collection.AddVectInfo( vi);
	  }	
	
	save_collection( argv[1], &collection);

     }
   
   return EXIT_SUCCESS;
}
