#include <stdlib.h>
#include <stdio.h>
#include "../DataSet.hpp"
#include "directory_parser.hpp"

int main( int argc, char **argv)
{
   string directory;
   string package_file;
   bool verbose = false;
   
   if ( argc < 3 )
     {
	fprintf( stderr, "%s: a tool to pack a directory in a dataset to be used with TinyPlanetViewer\n");
	fprintf( stderr, "Copyright 2004, Jean-christophe Duberga, jeanchristophe.duber@free.fr Licensed under GPL\n");     
	fprintf( stderr, "\n");
	fprintf( stderr, "usage: %s <directory_to_pack> <package.pkg> [-v]\n", argv[0]);
	fprintf( stderr, "options:\n");
	fprintf( stderr, "       -v --verbose            list packed files\n");
	exit( EXIT_FAILURE);
     }
   else
     {
	directory = argv[1];
	package_file = argv[2];
     
	for( int arg=3 ; arg<argc ;arg++)
	  {
	     if ( strcmp( argv[arg], "-v") == 0 || strcmp( argv[arg], "--verbose") == 0)
	       verbose = true;
	  }
     }
   
   DataSet ds;
   
   ds.SetBasePath( directory);
   
   DirectoryParser dp;
   
   dp.Init( directory, NULL, PARSE_DIRECTORY_OMIT_DIRECTORIES);
   
   File *file;
   
   while( (file = dp.GetNextFile()) != NULL)
     {
	if ( verbose)
	  fprintf( stderr, "%s\n", file->GetFileNameRelativePath().c_str());
    
	ds.AddFile( file->GetFileNameRelativePath().c_str());
     }
  
   ds.Save( package_file);
  
   fprintf( stderr, "Done\n");
   
#ifdef _DEBUG
   
   ds.DumpIndex();
   
   DataSet ds2;
   
   ds2.Open( package_file);
   
   ds2.DumpIndex();
   
#endif /* _DEBUG */
   
}
