#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <vector>
using namespace std;

#define TOLERANCE 0.0001f

// TODO: process in reverse until no change

struct Coord
{
   float lat_deg;
   float lon_deg;
};

struct Line
{
   vector< Coord> points;
};


void ConcatLine( Line *l1, Line *l2)
{
   for( unsigned int p = 1 ; p < l2->points.size() ; p++)
     l1->points.push_back( l2->points[p]);
}


int main( int argc, char **argv)
{
   
   if ( argc < 3)
     {
	fprintf( stderr, "usage: %s <input_file.txt> <output_file.txt>\n", argv[0]);
	exit( EXIT_FAILURE);
     }
   
   // Load lines from file  
   FILE *f;
   char line[1024];
   float lon, lat;
   Line *current_line;   
   vector< Line *> lines;
   vector< bool> lines_b; 
   unsigned int nb_points = 0; 
   
   f = fopen( argv[1], "r");
   
   if ( f == NULL )
     {
	fprintf( stderr, "%s: can't open input file %s\n", argv[0], argv[1]);
	exit( EXIT_FAILURE);
     }
   
   while( !feof( f))
     {
	fgets( line, 1024, f);
	
	if ( line[0] == '#')
	  {
	     current_line = new Line();
	     lines.push_back( current_line);
	     lines_b.push_back( false);
	  }
	else
	  {
	     
	     sscanf( line, "%f %f", &lat, &lon); 
	     Coord c;
	     c.lat_deg = lat;
	     c.lon_deg = lon;
	     current_line->points.push_back( c);
	     nb_points++;
	  }
     }
   
   fclose( f);

   // Display Statistics
   
   fprintf( stdout, "- Statistics for input file %s -------------------------------\n", argv[1]); 
   fprintf( stderr, "lines = %d\n", lines.size());
   fprintf( stderr, "total of points = %d\n", nb_points);
   fprintf( stderr, "average points per line = %f\n", ((float)nb_points)/((float)lines.size()));
   fprintf( stderr, "--------------------------------------------------------------\n");
   
   // Construct joined_lines
   
   vector< Line *> joined_lines;
   
   for( unsigned int l1 = 0 ; l1 < lines.size() ; l1++)
     {
	// pass this line if it have already been puted in joined_lines
	if ( lines_b[l1])
	  continue;
	
	joined_lines.push_back( lines[l1]);
	lines_b[l1] = true;
	
	bool joint_found = true;
	
	while( joint_found)
	  {
	     Coord cc_l1_end = lines[l1]->points[lines[l1]->points.size()-1];
	     joint_found = false;
	     
	     for( unsigned int l2=l1+1;l2<lines.size();l2++)
	       {
		  if ( lines_b[l2])
		    continue;
		  
		  Coord cc_l2_first = lines[l2]->points[0];
		  
		  if ( (fabs( cc_l1_end.lat_deg - cc_l2_first.lat_deg ) < TOLERANCE) &&
		       (fabs( cc_l1_end.lon_deg - cc_l2_first.lon_deg ) < TOLERANCE)    )
		    {
		       ConcatLine( lines[l1], lines[l2]);
		       joint_found = true;
		       lines_b[l2] = true;
		    }   
	       }	     
	  }
     }
   
   // Display Statistics for iutput file
   
   fprintf( stdout, "- Statistics for output file %s -------------------------------\n", argv[1]); 
   fprintf( stderr, "lines = %d\n", joined_lines.size());
   fprintf( stderr, "total of points = %d\n", nb_points);
   fprintf( stderr, "average points per line = %f\n", ((float)nb_points)/((float)joined_lines.size()));
   fprintf( stderr, "--------------------------------------------------------------\n");
   
   f = fopen( argv[2], "w");
   
   if ( f == NULL )
     {
	fprintf( stderr, "%s: can't open output file %s\n", argv[0], argv[2]);
	exit( EXIT_FAILURE);
     }
   
   for( unsigned int jl = joined_lines.size()-1 ; jl >= 0 ; jl--)
     {	
	fprintf( f, "# -b %d \n", jl); 
     
	for( unsigned int p = 0 ; p < joined_lines[jl]->points.size() ; p++)
	  fprintf( f, "%f %f\n", joined_lines[jl]->points[p].lat_deg, joined_lines[jl]->points[p].lon_deg);
     }
   
   fclose( f);
	
   return EXIT_SUCCESS;
}
