#ifndef _GEOIMAGE_HPP
#define _GEOIMAGE_HPP

#include "zone.hpp"

class GeoImage
{
 public:
   GeoImage();
   ~GeoImage();
   
   void LoadInfos( char *filename);
   void LoadImage();
   void UnloadImage();

   inline bool IsInside( double lon, double lat) {return zone.IsInside( lon, lat);}
   inline bool ImageLoaded() { return image_ready;}
   unsigned int GetPixel( unsigned int x, unsigned int y);
   unsigned int GetPixel( double lon, double lat);
   
 private:
   // Infos
   char *filename;
   Zone zone;
   bool infos_ready;
   unsigned int image_width;
   unsigned int image_height;
  
   // Image
   unsigned int *image;
   bool image_allocated;
   bool image_ready;
};

#endif
