#include <stdlib.h>
#include <stdio.h>
#include "rawimage.hpp"


int main( int argc, char **argv)
{

   RawImage ri;
   ri.OpenFile("/mnt/win_d/BLUE_MARBLE_DATA/BM_west.raw", 21600, 21600);

   FILE *f_out = fopen( "/mnt/win_d/BLUE_MARBLE_DATA/BM_west_downres.raw", "w");
   
   if ( f_out == NULL )
     {
	fprintf( stderr, "can't open output file\n");
	exit (EXIT_FAILURE);
     }
      
   for( unsigned int y=0; y<21600/2 ; y++)
     for( unsigned int x=0;x < 21600/2 ;x++)
       {
	  unsigned char comp[3];
	  
	  comp[0] = ( ri.GetPixelComp( x*2,   y*2,   RawImage::R) +
		      ri.GetPixelComp( x*2+1, y*2,   RawImage::R) +
		      ri.GetPixelComp( x*2+1, y*2+1, RawImage::R) +
		      ri.GetPixelComp( x*2,   y*2+1, RawImage::R) ) / 4;
	  
	  comp[1] = ( ri.GetPixelComp( x*2,   y*2,   RawImage::G) +
		      ri.GetPixelComp( x*2+1, y*2,   RawImage::G) +
		      ri.GetPixelComp( x*2+1, y*2+1, RawImage::G) +
		      ri.GetPixelComp( x*2,   y*2+1, RawImage::G) ) / 4;
	  
	  comp[2] = ( ri.GetPixelComp( x*2,   y*2,   RawImage::B) +
		      ri.GetPixelComp( x*2+1, y*2,   RawImage::B) +
		      ri.GetPixelComp( x*2+1, y*2+1, RawImage::B) +
		      ri.GetPixelComp( x*2,   y*2+1, RawImage::B) ) / 4;
	  
	  fwrite( comp, 1, 3, f_out);
       }
   
   
   fclose( f_out);
   
   fprintf( stderr, "Done\n");
}
