#ifndef _DIRECTORY_PARSER_HPP
#define _DIRECTORY_PARSER_HPP

#include <dirent.h>
#include <string>
#include <vector>
#include <stack>

#define PARSE_DIRECTORY_OMIT_DIRECTORIES 1
#define PARSE_DIRECTORY_ONLY_DIRECTORIES 2
#define PARSE_DIRECTORY_ORDER_BY_NAME    4

using namespace std;

struct File
{
   string name;
   string relative_path;
   string base_path;
   enum type
     {
	Regular,
	Directory,
	Link,
     } type;

   inline string GetFileNameFullPath() { return ((base_path!="")?base_path+"/":"")+((relative_path!="")?relative_path+"/":"")+name;}
   inline string GetFileNameRelativePath() { return ((relative_path!="")?relative_path+"/":"")+ name;}
   
};

struct Directory
{
   Directory( string base_path, string relative_path, string name);
   string name;
   string relative_path;
   string base_path;
   unsigned int current_position;
   vector< File *> files;
};

typedef vector<string> file_extensions;

struct Directory;

class DirectoryParser
{
 public:
   DirectoryParser();
   ~DirectoryParser();
   
   int Init( string path, file_extensions *known_file_extensions, int options);
   File *GetNextFile(); // return next file and NULL if there is no more.
   
 private:
   
   bool IsFileKnown( string filename);

   string root_directory;
   file_extensions *known_file_extensions;
   int options;
   stack< Directory *> directories_stack;
   Directory *current_directory;
};

#endif
