#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h>
#include <errno.h>
#include <fnmatch.h>
#include "directory_parser.hpp"

Directory::Directory( string base_path, string relative_path, string name)
{
   this->base_path = base_path;
   this->relative_path = relative_path;
   this->name = name;
   
   DIR *dir;
   struct dirent *namelist;
   static struct stat state;
   
   File *file; 

   dir = opendir( (((base_path!="")?base_path+"/":"")+relative_path).c_str());

//   fprintf( stderr, "ENTER DIRECTORY %s\n", (((base_path!="")?base_path+"/":"")+relative_path).c_str());
   if ( dir == NULL ) 
     {
	fprintf( stderr, "Directory::Read: can't open directory %s\n", (((base_path!="")?base_path+"/":"")+relative_path).c_str()) ;
	return;
     }
   
   namelist = readdir( dir);
   
   // for all files in the directory
	
   while ( namelist != NULL) 
     {  
 	
	// Don't process . and .. files
	     
	if ( ! (strcmp(".", namelist->d_name) && strcmp("..", namelist->d_name))) 
	  {
	     //fprintf( stderr, "skip it\n");
	     namelist = readdir( dir) ;
	     continue;
	  }
	
	//fprintf( stderr, "process it\n");
	
	// Is it a subdirectory ?
	     
	string filename = ((base_path!="")?base_path+"/":"") + ((relative_path!="")?relative_path+"/":"") + string("/") + string(namelist->d_name);
	
	if ( stat( filename.c_str(), &state) == -1)
	  fprintf( stderr,"Directory: stat error on file %s: %d\n", filename.c_str(), errno) ;
	
	if ( S_ISDIR( state.st_mode) || S_ISLNK( state.st_mode)) 
	  {
	     //fprintf( stderr,"DIRECTORY %s\n", namelist->d_name) ;
	     file = new File;
	     file->name = string( namelist->d_name); 
	     file->base_path = base_path;
	     file->relative_path = relative_path;//!="")?relative_path+"/":""+string( namelist->d_name);
	     file->type = File::Directory;
	     files.push_back( file);
	  }
	
	// this is a file, is it matching pattern ?
	     
	else //if ( IsFileKnown( string( namelist->d_name))) 
	  {	
	     //fprintf( stderr, "REGULAR\n");
	     file = new File;
	     file->name = string( namelist->d_name); 
	     file->base_path = base_path;
	     file->relative_path = relative_path;	     
	     file->type = File::Regular;
	     files.push_back( file);
	  }      
	
	namelist = readdir( dir) ;
     } 
   
   closedir( dir);

}

DirectoryParser::DirectoryParser()
{
}

DirectoryParser::~DirectoryParser()
{
}

int DirectoryParser::Init( string path, file_extensions *known_file_extensions, int options) 
{
   
   // Copy parameters
   
   this->root_directory = path;
   this->known_file_extensions = known_file_extensions;
   this->options = options;
   
   // Create root directoy and put it on the stack
   
   current_directory = new Directory( path, "", "");
   current_directory->current_position = 0;
   directories_stack.push( current_directory) ;
   
   return 1;
}

File *DirectoryParser::GetNextFile() 
{
   while( !directories_stack.empty() ) 
     {	
      
//	current_directory = directories_stack.top();
	
	// for all files in the directory
	
	while ( current_directory->current_position < current_directory->files.size()) 
	  {  
	     
	     File *current_file = current_directory->files[current_directory->current_position];

	     current_directory->current_position++;

	     if ( current_file->type != File::Directory )
	       {
		  return current_file;
	       }
	     else
	       {
		  
		  // Create new subdirectoy and put it on top of the stack
	     	  
//		  fprintf( stderr, "PUSH NEW DIRECTORY\n");
		  Directory *new_directory = new Directory( current_directory->base_path,
							    ((current_file->relative_path!="")?current_file->relative_path+"/":"")+current_file->name,
							    "");

		  new_directory->current_position = 0;

		  // Then push it on stack

		  directories_stack.push( new_directory);
		  current_directory = new_directory;

	       }  
	  }
	
	delete current_directory;
	directories_stack.pop();
	
	if ( !directories_stack.empty())
	  {
	     current_directory = directories_stack.top();
	//     fprintf( stderr,"POP (sortie repertoire)\n");
	  }
	else
	  {
	  //   fprintf( stderr, "End of search\n");
	  }
     }
   
   return NULL;	
}


bool IsFileExtensionKnown( string filename, file_extensions *known_file_extensions)
{ 
   for( unsigned int t=0;t<known_file_extensions->size();t++)
     {	
	if ( fnmatch( (char *)(( string("*") + (*known_file_extensions)[t]).c_str() ),
		      (char *)(filename.c_str() ), 
		      FNM_CASEFOLD) == 0 )
	  {		  
	     return true;
	  }
     }
   
   return false;
}

bool DirectoryParser::IsFileKnown( string filename)
{ 
   if ( known_file_extensions == NULL)
     return true;
   
   for( unsigned int t=0;t<known_file_extensions->size();t++)
     {	
	if ( fnmatch( (char *)(( string("*") + (*known_file_extensions)[t]).c_str() ),
		      (char *)(filename.c_str() ), 
		      FNM_CASEFOLD) == 0 )
	  {		  
	     return true;
	  }
     }
   
   return false;
}
