#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL.h>
#include <SDL_endian.h>
#include <SDL_image.h>
#include "VSDL.hpp"
//#include "../gl_stuff.hpp"

#define FILENAME_MAX_LENGTH 1024

void info( char* argv0)
{
   fprintf( stdout, "%s: compress textures for use with opengl.\n",argv0);
   fprintf( stdout, "Written in 2003 by Jean-Christophe Duberga, licensed under GPL\n");
   fprintf( stdout, "Supported formats: BMP, PNG, JPEG, TIFF, TGA, PCX, GIF\n");
}

#ifdef USE_TEXTURE_COMPRESSION

void usage( char *argv0)
{
   fprintf( stderr, "usage: %s [--stdin] [--mipmap] <original_texture> [compressed_texture] \n", argv0);
   fprintf( stderr, "       --stdin      read filenames from stdin\n");
   fprintf( stderr, "       --mipmap     store lod in the file\n");
   
   exit( EXIT_FAILURE);
}
  
int main( int argc, char **argv)
{
   info( argv[0]);
   
   bool read_from_stdin = false;
   bool build_mipmap = false;
   char input_filename[FILENAME_MAX_LENGTH];
   char output_filename[FILENAME_MAX_LENGTH];
   int arg_file1;
   int arg_file2;
   // Parse arguments
   
   if ( argc<1)
     {
	usage( argv[0]);
     }
   
   for(int i=1;i<argc;i++) 
     {
	if ( strcmp( argv[i], "--help") == 0 )
	  usage( argv[0]);
	else if ( strcmp( argv[i], "--stdin") == 0 )
	  read_from_stdin = true;
	else if ( strcmp( argv[i], "--mipmap") == 0 )
	  build_mipmap = true;
	else
	  {
	     strncpy( input_filename, argv[i], FILENAME_MAX_LENGTH);
	     if ( ++i < argc)
	       strncpy( output_filename, argv[i], FILENAME_MAX_LENGTH);
	     else
	       strcpy( output_filename, "default.ct");
	     break;
	  }
     }
   
   if ( read_from_stdin)
     fprintf( stdout, "Reading from stdin...\n");
   
   GLuint original_texture;
   GLint width, height;
   GLint *compressed_format;
   GLint num_compressed_format=0;
   GLint compressed=0;
   GLint internal_format;
   GLint compressed_size;
   
   // Init OpenGL
   SDL_Window *win = new SDL_Window( 640, 480, 0, "test_chunk - demonstration for chunk LOD");

   bool work_in_progress = true;
   
   while( work_in_progress)
     {
	// Load texture in system memmory
	Uint8 *rowhi, *rowlo;
	Uint8 *tmpbuf, tmpch;
	SDL_Surface *image, *image2;
	SDL_PixelFormat glPixelFormat;
	int i, j;
	
	if ( read_from_stdin)
	  {
	     fscanf( stdin, "%s", input_filename);
	     if ( feof( stdin))
	       work_in_progress = false;
	  }
	else
	  {
	     work_in_progress = false;
	  }
	
	image2 = IMG_Load( input_filename) ;
	
	if ( image2 == NULL ) {
	   fprintf(stderr, "Unable to load %s: %s\n", input_filename, SDL_GetError());
	   exit( EXIT_FAILURE);
	}
	
	glPixelFormat.palette = NULL ;
	glPixelFormat.BitsPerPixel = 24 ;
	glPixelFormat.BytesPerPixel = 3 ;
	glPixelFormat.Bmask = 0xFF0000;
	glPixelFormat.Gmask = 0x00FF00 ;
	glPixelFormat.Rmask = 0x0000FF ;
	glPixelFormat.Amask = 0x000000 ;
	glPixelFormat.Bshift = 0x10 ; 
	glPixelFormat.Gshift = 0x8 ; 
	glPixelFormat.Rshift = 0x0 ; 
	glPixelFormat.Ashift = 0 ;
	glPixelFormat.Rloss = 0 ; 
	glPixelFormat.Gloss = 0 ; 
	glPixelFormat.Bloss = 0 ; 
	glPixelFormat.Aloss = 0x8 ;
	glPixelFormat.colorkey = 0x0 ;
	glPixelFormat.alpha = 0xFF ;
	
	image = SDL_ConvertSurface( image2, &glPixelFormat, SDL_SWSURFACE) ;
	
	if ( image == NULL ) {
	   printf("erreur de conversion\n") ;
	   SDL_FreeSurface( image2) ;
	   return( 0) ;
	}
	
	SDL_FreeSurface( image2) ;
	
	width = image->w;
	height = image->h;
	
	// Enumerate supported compression formats 
	glGetIntegerv( GL_NUM_COMPRESSED_TEXTURE_FORMATS, &num_compressed_format);
	
	compressed_format = (GLint*)malloc( num_compressed_format * sizeof(GLint));
	
	glGetIntegerv( GL_COMPRESSED_TEXTURE_FORMATS, compressed_format);

# ifdef DEBUG_VERBOSE

	fprintf( stdout, "List of supported compression formats (%d):\n", num_compressed_format);
	for(unsigned int f=0;f<num_compressed_format;f++)
	  fprintf( stderr, " %d\n", compressed_format[f]);
	
# endif
	// Upload texture to video memmory
	glGenTextures( 1, &original_texture);
	glBindTexture( GL_TEXTURE_2D, original_texture);
	
	// TODO
	//check_gl_error( "glGenTextures,glBindTexture");
	
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri( GL_TEXTURE_2D, GL_GENERATE_MIPMAP_SGIS, build_mipmap?GL_TRUE:GL_FALSE);
	//glPixelStorei( GL_UNPACK_ALIGNMENT, 1) ;
	
	glTexImage2D( GL_TEXTURE_2D, 0, GL_COMPRESSED_RGB, width, height, 
		      0, GL_RGB, GL_UNSIGNED_BYTE, image->pixels);
	
	// TODO
	//check_gl_error( "glTexImage2D");
	
	GLint nb_lod, current_lod;
	
	if ( build_mipmap)
	  nb_lod = 5; 
	else
	  nb_lod = 1;

	//glGetTexParameteriv( GL_TEXTURE_2D, GL_TEXTURE_MAX_LOD, &nb_lod);
	//fprintf( stderr, "nb_lod = %d\n", nb_lod);
	     
	// Open output file
	 
	char out_filename[1024];
	  {
	     int pt =  strlen( input_filename)-3;
	     strncpy( out_filename, input_filename, pt);
	     out_filename[pt-1] = '\0';
	     strcat( out_filename, ".ct");
	  }
	
	SDL_RWops* f = SDL_RWFromFile( out_filename, "wb");
	
	if ( f == NULL)
	  {
	     fprintf( stderr, "Error writting to file %s\n", out_filename);
	     exit( EXIT_FAILURE);
	  }
	
	char *signature = "CT";
	SDL_RWwrite( f, signature, 1, 2);
	SDL_WriteLE16( f, nb_lod);
	
	// process each lod
	
	for( current_lod = 0 ; current_lod < nb_lod; current_lod++) 
	  
	  {
	     
	     glGetTexLevelParameteriv( GL_TEXTURE_2D, current_lod, GL_TEXTURE_COMPRESSED, &compressed);
	     
	     if ( compressed != GL_TRUE)
	       {
		  fprintf( stderr, "opengl don't want to compress the texture!\n");
		  // TODO clean
		  exit( EXIT_FAILURE);
	       }
	     
	     glGetTexLevelParameteriv( GL_TEXTURE_2D, current_lod, GL_TEXTURE_INTERNAL_FORMAT, &internal_format);
	     glGetTexLevelParameteriv( GL_TEXTURE_2D, current_lod, GL_TEXTURE_COMPRESSED_IMAGE_SIZE, &compressed_size);
	     glGetTexLevelParameteriv( GL_TEXTURE_2D, current_lod, GL_TEXTURE_WIDTH, &width);
	     glGetTexLevelParameteriv( GL_TEXTURE_2D, current_lod, GL_TEXTURE_HEIGHT, &height);
	     // Download compressed texture to system memory
   	     
	     unsigned char *img = (unsigned char *)malloc( compressed_size * sizeof(unsigned char));
	     
	     glGetCompressedTexImage( GL_TEXTURE_2D, current_lod, img);
	     
	     // Save compressed texture to disk
       	      
	     SDL_WriteLE16( f, width);
	     SDL_WriteLE16( f, height);
	     SDL_WriteLE32( f, internal_format);
	     SDL_WriteLE32( f, compressed_size);
	     
	     SDL_RWwrite( f, img, sizeof(unsigned char), compressed_size);

# ifdef DEBUG_VERBOSE
	     fprintf( stdout, "internal format = %d\n", internal_format);
	     fprintf( stdout, "width = %d\n", width);
	     fprintf( stdout, "height = %d\n", height);
	     fprintf( stdout, "sizeof of compressed file = %d\n", compressed_size);
	     fprintf( stdout, "-------------------------------------------\n");
# endif     

	     free( img);

	  }
	
	SDL_RWclose(f);
	
	fprintf( stderr, "readed: %s -> writen: %s (%d lod)\n", input_filename, out_filename, nb_lod); 
	// Clean
	free( compressed_format);     
	SDL_FreeSurface( image);
	glDeleteTextures( 1, &(original_texture));
	     	
	// Summarize in log
	     
     }
}

   
#else
   
int main( int argc, char **argv)
{
   info( argv[0]);
   
   fprintf( stderr, "\nSorry, chunkedTerrain is compiled without support for texture compression\n");
   fprintf( stderr, "Enable texture compression first if you want to use this tool:\n");
   fprintf( stderr, "#./configure --enable-texture-compression\n");
   fprintf( stderr, "And recompile.\n");
}

#endif // USE_TEXTURE_COMPRESSION
