#include <math.h>
#include "../Node.hpp"
#include "../Texture.hpp"
#include <GL/glu.h>

#define RESOLUTION_W 512
#define RESOLUTION_H 512

#define DEFAULT_BASE_LEVEL 4
#define DEFAULT_PLANE 'S'

char tmp[1024];

int main( int argc, char **argv)
{
   int base_lod = DEFAULT_BASE_LEVEL;
   char plane = DEFAULT_PLANE;
   
   /* Process parameters */
   
   for(int a=1;a<argc;a++) 
     {
	if ( strcmp( argv[a], "--help") == 0 ) 
	  {
	     fprintf( stdout, "usage: %s [options]\n\n", argv[0]) ;
	     fprintf( stdout, "options are:\n") ;
	     fprintf( stdout, "  --help           Display this help notice\n") ;
	     fprintf( stdout, "  --base-lod lod   Build level lod (default %d)\n", DEFAULT_PLANE) ;
	     fprintf( stdout, "  --plane id       Select plane to build: N|S|F|B|E|W\n");
	     return EXIT_FAILURE;
	  }
	else if ( strcmp( argv[a], "--base-lod") == 0 )
	  {
	     if ( a+1 < argc )
	       {
		  base_lod = atol( argv[++a]);
	       }
	     else
	       {
		  fprintf( stderr, "--base-lod must be followed by an integer\n");
		  return EXIT_FAILURE;
	       }
	  }
	else if ( strcmp( argv[a], "--plane") == 0 )
	  {
	     if ( a+1 < argc )
	       {
		  plane = argv[++a][0];
	       }
	     else
	       {
		  fprintf( stderr, "--plane must take a plane id\n");
		  return EXIT_FAILURE;
	       }
	  }
     }
     
   fprintf( stderr, "Building plane %c\n", plane);

   for ( int level = base_lod-1 ; level >= 0 ; level--)
     {
	unsigned int level_width = powf( 2, level);

	fprintf( stderr, "\nlevel %d (%dx%d)\n", level, level_width, level_width); 

	for( unsigned int y = 0 ; y < level_width ; y++)
	  for( unsigned int x = 0 ; x < level_width; x++)
	    {
	       Node node = Node( level, x, y, Cube::GetFace(plane));
	       
	       // Load the 4 sources textures  
	       
	       Texture t1;
	       sprintf( tmp, "earth_cobe/%c/%04d.bmp", plane, node.GetChild(0).GetNumber());
	       t1.LoadImage( tmp);
	       
	       Texture t2;
	       sprintf( tmp, "earth_cobe/%c/%04d.bmp", plane, node.GetChild(1).GetNumber());
	       t2.LoadImage( tmp);
	
	       Texture t3;
	       sprintf( tmp, "earth_cobe/%c/%04d.bmp", plane, node.GetChild(2).GetNumber());
	       t3.LoadImage( tmp);
	       
	       Texture t4;
	       sprintf( tmp, "earth_cobe/%c/%04d.bmp", plane, node.GetChild(3).GetNumber());
	       t4.LoadImage( tmp);
		       
	       // Create intermediate Texture
	       Texture intermediate;
	       intermediate.CreateFromScratch( RESOLUTION_W*2, RESOLUTION_H*2, GL_RGB);
	       
	       for (unsigned int py=0 ; py < RESOLUTION_H ; py++)
		 for (unsigned int px=0 ; px < RESOLUTION_W ; px++)
		   {
		      intermediate.SetPixelComp( px, RESOLUTION_H*2-1-py, Texture::R, t3.GetPixelComp( px, 511-py, Texture::R));
		      intermediate.SetPixelComp( px, RESOLUTION_H*2-1-py, Texture::G, t3.GetPixelComp( px, 511-py, Texture::G));
		      intermediate.SetPixelComp( px, RESOLUTION_H*2-1-py, Texture::B, t3.GetPixelComp( px, 511-py, Texture::B));

		      intermediate.SetPixelComp( px+RESOLUTION_W, RESOLUTION_H*2-1-py, Texture::R, t4.GetPixelComp( px, 511-py, Texture::R));
		      intermediate.SetPixelComp( px+RESOLUTION_W, RESOLUTION_H*2-1-py, Texture::G, t4.GetPixelComp( px, 511-py, Texture::G));
		      intermediate.SetPixelComp( px+RESOLUTION_W, RESOLUTION_H*2-1-py, Texture::B, t4.GetPixelComp( px, 511-py, Texture::B));

		      intermediate.SetPixelComp( px, RESOLUTION_H*2-1-(py+RESOLUTION_H), Texture::R, t1.GetPixelComp( px, 511-py, Texture::R));
		      intermediate.SetPixelComp( px, RESOLUTION_H*2-1-(py+RESOLUTION_H), Texture::G, t1.GetPixelComp( px, 511-py, Texture::G));
		      intermediate.SetPixelComp( px, RESOLUTION_H*2-1-(py+RESOLUTION_H), Texture::B, t1.GetPixelComp( px, 511-py, Texture::B));

		      intermediate.SetPixelComp( px+RESOLUTION_W, RESOLUTION_H*2-1-(py+RESOLUTION_H), Texture::R, t2.GetPixelComp( px, 511-py, Texture::R));
		      intermediate.SetPixelComp( px+RESOLUTION_W, RESOLUTION_H*2-1-(py+RESOLUTION_H), Texture::G, t2.GetPixelComp( px, 511-py, Texture::G));
		      intermediate.SetPixelComp( px+RESOLUTION_W, RESOLUTION_H*2-1-(py+RESOLUTION_H), Texture::B, t2.GetPixelComp( px, 511-py, Texture::B));
		   }
	       
	       
	       // Create final texture
	       Texture final;
	       final.CreateFromScratch( RESOLUTION_W, RESOLUTION_H, GL_RGB);
	       
	       //gluScaleImage ( GL_RGB, 512, 512, GL_UNSIGNED_BYTE, intermediate.GetPixelsPtr(), 256, 256, GL_UNSIGNED_BYTE, final.GetPixelsPtr());
	       
	       //gluScaleImage (GLenum format, GLsizei wIn, GLsizei hIn, GLenum typeIn, const void *dataIn, GLsizei wOut, GLsizei hOut, GLenum typeOut, GLvoid* dataOut);

	       //intermediate.Resample( RESOLUTION_W, RESOLUTION_H);

	       for (unsigned int py=0 ; py < RESOLUTION_H ; py++)
		 for (unsigned int px=0 ; px < RESOLUTION_W ; px++)
		   {
		      final.SetPixelComp( px, py, Texture::R, 
					  ((int)intermediate.GetPixelComp( px*2,   py*2,   Texture::R)+
					  (int)intermediate.GetPixelComp( px*2+1, py*2,   Texture::R)+
					  (int)intermediate.GetPixelComp( px*2+1, py*2+1, Texture::R)+
					  (int)intermediate.GetPixelComp( px*2,   py*2+1, Texture::R))/4); 

		      final.SetPixelComp( px, py, Texture::G, 
					  ((int)intermediate.GetPixelComp( px*2,   py*2,   Texture::G)+
					  (int)intermediate.GetPixelComp( px*2+1, py*2,   Texture::G)+
					  (int)intermediate.GetPixelComp( px*2+1, py*2+1, Texture::G)+
					  (int)intermediate.GetPixelComp( px*2,   py*2+1, Texture::G))/4);

		      final.SetPixelComp( px, py, Texture::B, 
					  ((int)intermediate.GetPixelComp( px*2,   py*2,   Texture::B)+
					  (int)intermediate.GetPixelComp( px*2+1, py*2,   Texture::B)+
					  (int)intermediate.GetPixelComp( px*2+1, py*2+1, Texture::B)+
					  (int)intermediate.GetPixelComp( px*2,   py*2+1, Texture::B))/4);

		      
		   }
	       
	       // Save final Texture
	       char filename[128];
	       sprintf( filename, "earth_cobe/%c/%04d.bmp", plane, node.GetNumber());
	       final.Save( filename);
	       
	       fprintf( stdout, "\r node %d     ", node.GetNumber()); 
	       fflush( stdout);
	    }   
     }
}
