#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <SDL.h>
#include <SDL_image.h>
#include "config.h"

#define DEFAULT_TABLE_WIDTH  1024
#define DEFAULT_TABLE_HEIGHT  512

int main( int argc, char *argv[])
{
   /* Process parameters */
   
   int table_width = DEFAULT_TABLE_WIDTH;
   int table_height = DEFAULT_TABLE_HEIGHT;
   int flag_width = 60;
   int flag_height = 36;
   int nb_flags_in_width = 17;
   int nb_flags_in_height = 14; 
   
   for( int a = 1 ; a < argc ; a++) 
     {
	if ( strcmp( argv[a], "--help") == 0 ) 
	  {
	     fprintf( stderr, "usage: %s [options]\n\n", argv[0]) ;
	     fprintf( stderr, "options are:\n") ;
	     fprintf( stderr, "  --help             Display this help notice\n") ;
	     fprintf( stderr, "  --width x          Set table width in pixels\n") ;
	     fprintf( stderr, "  --height y         Set table height in pixels\n") ;
	     //...
	     exit( EXIT_FAILURE) ;
	  }
	else if ( strcmp( argv[a], "--width") == 0 )
	  ;
	else if ( strcmp( argv[a], "--height") == 0 )
	  ;
	else
	  fprintf( stderr, "%s: unknow parameter %s\n", argv[0], argv[a]);
     }
   
   // Init SDL

   if ( SDL_Init( SDL_INIT_VIDEO) < 0 ) 
     {
	fprintf( stderr, "%s: can't init video!\n", argv[0]);
	exit( EXIT_FAILURE);
     }
    

   // Create table surface
   
   SDL_Surface *table = SDL_CreateRGBSurface( SDL_SWSURFACE, 
					      table_width, 
					      table_height,
					      24,
					      0x00FF0000, 
					      0x0000FF00,
					      0x000000FF,
					      0);   
   
   if ( table == NULL ) 
     {
	fprintf( stderr, "%s: table allocation failed!\n", argv[0]);
	exit( EXIT_FAILURE);
     }

   // Open flags table definition file
 
   FILE* fdf = fopen( "national_flags.txt", "r");
   if ( fdf == NULL )
     {
	fprintf( stderr, "%s: can't open flags definition file %s\n", argv[0], "national_flags.txt");
	SDL_FreeSurface( table);
	exit( EXIT_FAILURE);
     }

   int flag_no = 0;
   
   while( ! feof( fdf))
     {
	char line[1024];
	char country[1024];
	char flag_file[1024];
	char flag_file2[1024];
	
	fgets( line, 1024, fdf);
	
	if ( line[0] == '#')
	  continue;
	
	sscanf( line, "\"%[^\"]\" %s", country, flag_file2); 

	sprintf( flag_file, "flags/%s", flag_file2);
	
	fprintf( stderr, "%s -> %s\n", country, flag_file);  
	
	SDL_Surface *flag = IMG_Load( flag_file);
	
	if ( flag == NULL ) 
	  {
	     fprintf( stderr, "%s: Unable to load flag %s (%s)\n", argv[0], flag_file, SDL_GetError());;
	     continue;
	  }
	
	SDL_Rect src = { 0, 0, flag_width, flag_height};
	SDL_Rect dst = { flag_width*(flag_no%nb_flags_in_width), flag_height*(flag_no/nb_flags_in_width), flag_width, flag_height};
	
	if ( SDL_BlitSurface( flag, &src, table, &dst) != 0 )
	  fprintf( stderr, "%s: Blit failed\n", argv[0]);
		
	SDL_FreeSurface( flag) ;
	flag_no++;
     }
   
   fprintf( stderr, "%s: Saving table width %d flags in %s\n", argv[0], flag_no, "flag.bmp");

   SDL_SaveBMP( table, "flags_table.bmp");
   SDL_FreeSurface( table);
   
   exit( EXIT_SUCCESS);
}
