#!/bin/bash

export ORIGINAL_DATA_PATH=/mnt/win_d/BLUE_MARBLE_DATA
export TMP_PATH=/mnt/win_d/TMP_DATA
export TARGET_PATH=/mnt/mdk_prod/tmp/blue_marble_bumped
export BASE_LOD=4
export FIRST_NODE=0
export LAST_NODE=1364
export TEXTURE_WIDTH=512
export TITLE="Blue Marble Bumped"

export BOUNDARIES_MAPGEN_FILE="Ressources/boundaries_joined.txt"
export COASTLINES_MAPGEN_FILE="Ressources/coastlines_brut.txt"
export     RIVERS_MAPGEN_FILE="Ressources/rivers_brut.txt"

make_arbo()
{
  if [ ! -d $TARGET_PATH ]; then
    mkdir $TARGET_PATH
  fi
  
  if [ ! -d $TARGET_PATH/config ]; then
    mkdir $TARGET_PATH/config
  fi
  
  for plane in F W B E N S
  do
    mkdir $TARGET_PATH/$plane 2> /dev/null
    mkdir $TMP_PATH/$plane 2> /dev/null
  done
}

make_config()
{
  echo "# Tiny Planet Configuration file" > $TARGET_PATH/config/planet.cfg
  echo "nb_lod = \"$BASE_LOD\"" >> $TARGET_PATH/config/planet.cfg
  echo "textures_width = \"$TEXTURE_WIDTH\"" >> $TARGET_PATH/config/planet.cfg
}

# -- Raster data ----------------------------------------------------------- #

project_rasters()
{
  ./project_ortho_cobe --input-raster $ORIGINAL_DATA_PATH/BM_west.raw --input-second-raster $ORIGINAL_DATA_PATH/BM_east.raw --input-dim 43200x21600 --output-prefix $TMP_PATH/BM --output-dim 8192x8192
}

build_raster_quadtree()
{
  for plane in F W B E N S
  do
    echo " "
    echo "- Build up quadtree for face $plane --------------- " 
    ./raster_build_quadtree --base-lod $BASE_LOD --face $plane --input-raster $TMP_PATH/BM_$plane.raw --input-dim 8192x8192 --output-prefix $TMP_PATH --output-dim 512x512 #$TEXTURE_WIDTHx$TEXTURE_WIDTH 
  done
}

# -- Vectorial data -------------------------------------------------------- # 

make_international_boundaries()
{
  for plane in F W B E N S
  do
    for lod in 0 1 2 3 4 5
    do
      ./build_vecto_base --mapgen-file $BOUNDARIES_MAPGEN_FILE --ext vbd --base-lod $lod --plane $plane --data-name "Boundaries" --dest-path $TARGET_PATH --print-statistics
    done
  done
}

make_coastlines()
{
 for plane in F W B E N S
  do
    for lod in 0 1 2 3 4 5
    do
      ./build_vecto_base --mapgen-file $COASTLINES_MAPGEN_FILE --ext vcl --base-lod $lod --plane $plane --data-name "Coastlines" --dest-path $TARGET_PATH --print-statistics
    done
  done
}

make_rivers()
{
 for plane in F W B E N S
  do
    for lod in 0 1 2 3 4 5
    do
      ./build_vecto_base --mapgen-file $RIVERS_MAPGEN_FILE --ext vrv --base-lod $lod --plane $plane --data-name "Rivers" --dest-path $TARGET_PATH --print-statistics
    done
  done
}

make_cities()
{
 for plane in F W B E N S
  do
    for lod in 0 1 2 3 4 5
    do
      ./build_vecto_pof --input-file --ext cities --base-lod $lod --plane $plane --data-name "Cities" --dest-path $TARGET_PATH --print-statistics
    done
  done
}

pack_vectinfo()
{
 for plane in F W B E N S
  do
    ./pack_vectinfo $TARGET_PATH/$plane --range $FIRST_NODE $LAST_NODE vnf vbd vcl vrv
  done
}

#make_arbo
#make_config

project_rasters
build_raster_quadtree
./compress_all $TMP_PATH

#make_international_boundaries
#make_coastlines
#make_rivers
#make cities
#pack_vectinfo


#for i in *.bmp; do convert $i ${i%.gif}.png
