#ifndef _VSDL_HPP
#define _VSDL_HPP

#include <SDL.h>
//#include <SDL_events.h>

#define FULLSCREEN 1
#define ACCEL      2
#define DOUBLEBUF  4
#define GL         8

class SDL_Window 
{
 public:
   SDL_Window( int width, int height, int flags, char* title) ;
   ~SDL_Window() ;
   int getWidth() ;
   int getHeight() ;
   void setColor( int r, int g, int b);
   void setForeground( int r, int g, int b);
   void setBackground( int r, int g, int b);
   void clear() ;
   void drawPoint( int x, int y) ;
   void drawLine( int x, int y, int x2, int y2) ;
   void drawVerticalLine( int x, int y1, int y2 ) ;
   void drawHorizontalLine( int x1, int y, int x2 ) ;
   void drawRect( int x, int y, int w, int h) ;
   void refresh() ;
   int waitFrame( int nb_msx) ;
   int pollEvent( SDL_Event* event) ;
   int getKey() ;
   int isButtonRelease() ;
   int getMouseEvents( SDL_Event* event) ;
   void getMouseCoords( int* x, int* y) ;
   int getJoystickEvents( SDL_Event* event) ;
   void showCursor( bool mode) ;
   void toggleFullScreen() ;
 private:
   int _lockSurface() ;
   void _unLockSurface() ;
   void _drawPoint( int x, int y) ;
   int videoReady ;
   int videoFlags ;   
   SDL_Surface *screen ;
   Uint32 currentColor ;
   Uint32 currentBackgroundColor ;
} ;

#endif
