#ifndef _RASTER_HPP
#define _RASTER_HPP

#include <string>

using namespace std;

struct Pixel
{
   float r;
   float g;
   float b;
};

class Raster
{
 public:
   Raster();
   virtual ~Raster();

   bool LoadImage( string filename);
   bool SaveImage( string filename);
   
   Pixel GetPixel( unsigned int x, unsigned int y);
   
   void SetPixel( unsigned int x, unsigned int y, Pixel p);
   
   // return textel sub-jacent surface in square meters
   virtual float GetPixelSurface( unsigned int x, unsigned int y);
   
   virtual Pixel GetPixelForSurface( unsigned int x, unsigned int y);
     
   unsigned int with;
   unsigned int height;
   Pixel* pixels;
};


class Raster_Ortho : public Raster
{
 public:
   float GetPixelSurface();
   Pixel GetPixelForSurface( unsigned int x, unsigned int y);
};

class Raster_COBE : public Raster
{
 public:
   float GetPixelSurface();
   Pixel GetPixelForSurface( unsigned int x, unsigned int y);
};



#endif /* _RASTER_HPP */
