#include <math.h>
#include "Raster.hpp"
#include "projection.hpp"
#include "Texture.hpp"

#define RESOLUTION_W 2048
#define RESOLUTION_H 2048

#define ORTHO_RESOLUTION_W 1024
#define ORTHO_RESOLUTION_H 1024

int main( int argc, char **argv)
{
   
   // Load source texture ( ortho projexction )
   Texture ortho;
   ortho.Load( "earth_ortho_l.png");
   
   // Create destination Texture
   Texture cobe;
   cobe.CreateFromScratch( RESOLUTION_W, RESOLUTION_H, GL_RGB);
   
   float x_step = 2.0f * CUBE_RAY / (float)RESOLUTION_W;
   float y_step = 2.0f * CUBE_RAY / (float)RESOLUTION_H;
   
   // Fill destination texture
   for(unsigned int y=0;y<RESOLUTION_H;y++)
     for( unsigned int x=0;x<RESOLUTION_W;x++)
       {
	  // front
	  float lat, lon;
	  
	  //Coord3DToPolar( Coord3D( -CUBE_RAY+((float)x)*x_step, -CUBE_RAY+((float)y)*y_step, CUBE_RAY), &lat, &lon);	  
	  
	  Coord3DToPolar( Coord3D( -CUBE_RAY+((float)x)*x_step, CUBE_RAY, -CUBE_RAY+((float)y)*y_step), &lat, &lon);	  
	  
	  unsigned int ox = ( lon + M_PI ) / ( 2.0f * M_PI ) * (float)ORTHO_RESOLUTION_W;
	  unsigned int oy = ( lat + M_PI/2.0f ) / ( M_PI) * (float)ORTHO_RESOLUTION_H;
	  
	  cobe.SetPixelComp( x, y, Texture::B, ortho.GetPixelComp( ox, oy, Texture::R) );
	  cobe.SetPixelComp( x, y, Texture::G, ortho.GetPixelComp( ox, oy, Texture::G) );
	  cobe.SetPixelComp( x, y, Texture::R, ortho.GetPixelComp( ox, oy, Texture::B) );
       }
  
   // Save destination Texture
   cobe.Save( "earth_cobe1.bmp");


}
