#include "sdlzlib.h"
#include <zlib.h>               /* gzopen, gzread */
#include <errno.h>              /* perror */
#include <SDL.h>
#include <SDL/SDL_error.h>      /* SDL_Error */

#ifdef __cplusplus
extern "C" {
#endif

/*
struct gzstdio
{
   FILE *fp;
   int autoclose;
};

#define GET_GZSTDIO(x) ((struct gzstdio *)(x.data1))
*/
   
static int sdlzlib_seek(SDL_RWops *context, int offset, int whence)
{
   
   int newpos;
   
   if ( (newpos = gzseek( context->hidden.unknown.data1, offset, whence)) != -1) 
     {	
	return newpos;
     }
   else 
     {
	
	SDL_Error(SDL_EFSEEK);
	return(-1);
     }
   
}


static int sdlzlib_read(SDL_RWops *context, void *ptr, int size, int maxnum)
{
   
   int nread;
   
   nread = gzread(context->hidden.unknown.data1, ptr, size * maxnum); 
   if ( nread < 0 ) 
     {	
	SDL_Error(SDL_EFREAD);
     }
   
   /* return number of items read, not number of bytes */
   return(nread / size);
}


static int sdlzlib_write(SDL_RWops *context, const void *ptr, int size, int num)
{
   
   size_t nwrote;
   
   nwrote = gzwrite(context->hidden.unknown.data1, ptr, size * num);
   if ( nwrote <= 0 ) 
     {
	
	SDL_Error(SDL_EFWRITE);
     }
   
   return(nwrote);
}


static int sdlzlib_close(SDL_RWops *context)
{
   
   if ( context ) 
     {
	
/*	if ( context->hidden.gzstdio.autoclose ) 
	  {
	     
	     // TODO:  Check the return value here 
	     gzclose(context->hidden.gzstdio.fp);
	  }
*/	
	SDL_FreeRW(context);
     }
   
       return(0);
}


/* 
 *  This function is a wrapper for SDL_RWFromFile which checks to see
 *  if the file is compressed with gzip and if so, uses zlib to operate
 *  on the compressed contents.  NOTE: mode must be either read-only or
 *  write-only, otherwise zlib will silently fail.
 */
SDL_RWops *SDLZlib_RWFromFile(const char *file, const char *mode)
{
   SDL_RWops *ops;
   FILE *fp;
   unsigned char magic[2];
   int nread;
       
   fp = fopen( file, mode);
   
   if (!fp)
     {	
	perror("SDL-zlib");
	return NULL;
     }
      
   nread = fread( magic, 1, 2, fp);
   if (nread != 2)
     {	
	perror("SDL-zlib");
	return NULL;
     }
   
   if (magic[0] == 0x1f && magic[1] == 0x8b)
     {
	
	/* gzip */
	fclose(fp);
	ops = SDL_AllocRW();
	if (ops != NULL) 
	  {
	     
	     ops->seek = sdlzlib_seek;
	     ops->read = sdlzlib_read;
	     ops->write = sdlzlib_write;
	     ops->close = sdlzlib_close;
	     ops->hidden.unknown.data1 = gzopen(file, mode);
	     if (ops->hidden.unknown.data1 == NULL)
	       {
		  
		  /* gzopen failed! */
		  ops = NULL;
	       }
	     
	  }
	
	return ops;
     }
   
   else
     {
	fprintf( stderr, "Not a zlib compressed file: call SDL_RWFrpmFP\n");
	fclose( fp);
	return SDL_RWFromFile( file, mode);
     }
}
   
#ifdef __cplusplus
}
#endif
