#include <SDL.h>
#include <SDL_endian.h>
#include "sdl_stuff.hpp"

#define BUFFER_SIZE 65536

Uint32 waitFrame( Uint32 fps) 
{
   static Uint32 next_tick = 0;
   Uint32 this_tick;
   int realfps;
   
   this_tick = SDL_GetTicks();
   if ( this_tick <= next_tick ) 
     {
	SDL_Delay( next_tick-this_tick);
	realfps = fps;
     }
   else 
     realfps = 1000/(1000/fps+this_tick-next_tick);
   
   next_tick = SDL_GetTicks() + (1000/fps) ; 
   return realfps; /* return the real fps */
}

char *SDL_RW_gets( char *s, int size, SDL_RWops *rops)
{
   int  total_bytes_readen = 0;
   int  nb_bytes_readen    = 1;
   char cur_character      = ' ';
   
   while ( cur_character != '\n' && total_bytes_readen < size-1 && nb_bytes_readen != 0)
     {
	nb_bytes_readen = SDL_RWread( rops, s+total_bytes_readen, sizeof(char), 1);
	total_bytes_readen += nb_bytes_readen;
	if ( nb_bytes_readen  == 1)
	  cur_character = *(s+total_bytes_readen-1);
     }
   
   if ( total_bytes_readen > 0 )
     {
	*(s+total_bytes_readen-1) = '\0';
	return s;
     }
   else
     return NULL;  
}

/*
char *SDL_RW_gets_v2( char *s, int size, SDL_RWops *rops)
{
   int nb_bytes_readen;
   char *cr;
   unsigned int initial_position;
  
   initial_position = SDL_RWtell( rops);
   
   nb_bytes_readen = SDL_RWread( rops, s, sizeof(char), size-1);

   if ( nb_bytes_readen == 0 )
     return NULL;
   
   s[size-1] = '\0';
   
   cr = index( s, '\n');
   
   if ( cr != NULL)
     {
	*(cr+1) = '\0';
	SDL_RWseek( rops, - nb_bytes_readen + (cr-s) , SEEK_CUR);
     }
   
   return s;
}*/

string sdl_ReadBinaryString( SDL_RWops* r_ops)
{
   string str;
   unsigned int str_length;
   
   str_length = SDL_ReadLE32( r_ops);
   
   char char_str[str_length+1];
   
   if ( SDL_RWread( r_ops, char_str, sizeof(char), str_length) ==  str_length)   
     {
	char_str[str_length] = '\0'; 
	str = char_str;
     }
   else
     throw string(  "sdl_ReadBinaryString: failed to read string");  
   
   return str;
}

void sdl_WriteBinaryString( SDL_RWops* w_ops, string str)
{
   SDL_WriteLE32( w_ops, str.length());
   
   if ( SDL_RWwrite( w_ops, str.c_str(), sizeof(char), str.length()) !=  str.length())   
     {	
	throw string(  "sdl_ReadBinaryString: failed to read string");  
     }
}

