#ifndef _PROJECTION_HPP
#define _PROJECTION_HPP

#include "config.h"
#include "math/Vector.hpp"

#define M_SQRT_3 1.73205080756887719318f
  
// Earth Paramters
#define RADIUS            0.5f
#define EPSILON         0.001f

// helpers
#define CUBE_RAY         (1.0f)    // (RADIUS/M_SQRT_3)           

struct Coord3D // Deprecated 
{
   Coord3D() {}
   
   inline Coord3D( tpv_float x, tpv_float y, tpv_float z) { c[0] = x; c[1] = y; c[2] = z;}
   
   tpv_float c[3];

   void Normalize();
};

namespace Cube
{

   enum Face
     {
	Front=0,
	East=1,
	Back=2,
	West=3,
	North=4,
	South=5
     };

   Face GetFace( char face);
   
   char GetFace( Face face);
		 
   struct Coord
     {
	Coord() {}
	inline Coord( float x, float y, Face face) { c[0]=x; c[1]=y; this->face=face;}
	
	Coord3D GetCoord3D( float cube_size);
     
	Face face;
	float c[2];
     };

   extern char FacePrefix[6];
};


// Projection cube -> sphere 

// deprecated
extern Coord3D PolarToCoord3D( tpv_float lat, tpv_float lon, tpv_float ray=RADIUS);

extern Vector3f PolarToCoord3f( tpv_float lat, tpv_float lon, tpv_float radius);

// deprecated
extern void Coord3DToPolar( Coord3D point, tpv_float *lat, tpv_float *lon);

extern void Coord3fToPolar( Vector3f point, tpv_float *lat, tpv_float *lon);

// deprecated
extern Coord3D CubeToSphere( Coord3D c_point);

extern Vector3f CubeToSphere3f( Vector3f c_point);

// Projection sphere -> cube

// deprecated
extern Coord3D SphereToCube( Coord3D s_point);

extern Cube::Coord PolarToCubeCoord( tpv_float lat_deg, tpv_float lon_deg);
  
#endif /* _PROJECTION_HPP */
