#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "gl_stuff.hpp"
#include "Line.hpp"


Line::Line()
{
}

Line::~Line()
{
}

inline float _dist( Coord3D p1, Coord3D p2)
{
   return sqrtf( p1.c[0]-p2.c[0]*p1.c[0]-p2.c[0] + 
		 p1.c[1]-p2.c[1]*p1.c[1]-p2.c[1] +
		 p1.c[2]-p2.c[2]*p1.c[2]-p2.c[2]  );
   
}

  
void Line::Resample( float precision)
{
   precision = 0.0f;//1.0f/512.0f;
   
   points_r.push_back( points[0]);
   
   Coord3D current_point = points[0];
   
   for( unsigned int p=1 ; p<points.size()-1; p++)
     {
		
	if ( _dist( points[p], current_point) > precision)
	  {
	     points_r.push_back( points[p]);
	     current_point = points[p];
	  }
	
	
     }
   
   
   points_r.push_back( points[points.size()-1]);


   fprintf( stderr, "Resampled from %d to %d\n", points.size(), points_r.size()); 
}

void Line::Draw()
{
   glBegin( GL_LINE_STRIP);
   
   for( unsigned int p=0 ; p<points.size(); p++)
     glVertex3fv( points[p].c);
   
   glEnd();  
}
