#ifndef _VECTORMATHS_HPP
#define _VECTORMATHS_HPP

#include <assert.h>
#include <iostream>
#include "Vector.hpp"

template <typename Obj,int SIZE>
class VectorMaths:public Vector<Obj,SIZE>
{
 public:
   VectorMaths(const VectorMaths<Obj,SIZE> &v):Vector<Obj,SIZE>(v)
     {}
   VectorMaths()
     {}
   void operator*=(const double scalaire)
     {
	for (int i=0;i<SIZE;++i)
	  (*this)[i]*=scalaire;
     }
   void operator+=(const Vector<Obj,SIZE> &vecto)
     {
	for (int i=0;i<SIZE;++i)
	  (*this)[i]+=vecto[i];
     }
   
   VectorMaths operator+(const Vector<Obj,SIZE> &vecto)
     {
	VectorMaths res=*this;
	res+=vecto;
	return res;
     }
   
   void operator-=(const Vector<Obj,SIZE> &vecto)
     {
	for (int i=0;i<SIZE;++i)
	  (*this)[i]-=vecto[i];
     }
   
   void fill(Obj obj)
     {
	for (int i=0;i<SIZE;++i)
	  (*this)[i]=obj;
     }
};

//Oprateurs externes
template <typename Obj,int SIZE>
ostream& operator<<(ostream &os,const Vector<Obj,SIZE> &vect)
{ 
   os << "[" ;
   if(SIZE>0)
     {
	os << vect[0]; 
	for (int i=1;i<SIZE;++i)
	  os << "," <<  vect[i];
     }
   os << "]" << endl;
   return os;
}

template <typename Obj,int SIZE>
Vector<Obj,SIZE> operator+(const Vector<Obj,SIZE>&v1,const Vector<Obj,SIZE>&v2)
{ 
   VectorMaths<Obj,SIZE> tmpV=v1;
   tmpV+=v2;
   return tmpV;
}

template <typename Obj,int SIZE>
VectorMaths<Obj,SIZE> operator-(const VectorMaths<Obj,SIZE>&v1,const VectorMaths<Obj,SIZE>&v2)
{ 
   VectorMaths<Obj,SIZE> tmpV=v1;
   tmpV-=v2;
   return tmpV;
}

template <typename Obj,int SIZE>
VectorMaths<Obj,SIZE> operator*(const VectorMaths<Obj,SIZE>&v1,const Obj& scalaire)
{
   VectorMaths<Obj,SIZE> tmpV=v1;
   tmpV*=scalaire;
   return tmpV;
}

template <typename Obj,int SIZE>
Obj operator*(const VectorMaths<Obj,SIZE>&v1, const VectorMaths<Obj,SIZE>&v2)
{
   Obj tmpO;
   assert (SIZE>0);
   tmpO= v1[0] * v2[0];
   for (int i=0;i<SIZE;++i)
     tmpO+= v1[i] * v2[i];
   return tmpO;
}

template <typename Obj,int SIZE>
VectorMaths<Obj,SIZE> operator*(const Obj &scalaire,const VectorMaths<Obj,SIZE>&v1)
{ return (v1*scalaire);}

#endif /* _MATRIX_MATH_HPP */
