#ifndef _VECTOR3D_H
#define _VECTOR3D_H

#include <assert.h>
#include "VectorMaths.h"
#include "Matrix4x4.h"

class Vector3D:public VectorMaths<double,3>
{
  public:
  Vector3D(const Vector3D &vecto):VectorMaths<double,3>(vecto)
    {}
  Vector3D(const VectorMaths<double,3>  &vecto):VectorMaths<double,3>(vecto)
    {}
  Vector3D(const double xx=0,const double yy=0,const double zz=0)
    {
      (*this)[0]=xx; (*this)[1]=yy; (*this)[2]=zz;
    }
  Vector3D perspective(double focale,double distance)
    {
      double tmp= focale / ( distance + (*this)[2]);
      return (Vector3D((*this)[0]*tmp,(*this)[1]*tmp));
    }
   double norme()
     {
      return sqrt( (*this)[0]*(*this)[0] + 
		   (*this)[1]*(*this)[1] + 
		   (*this)[2]*(*this)[2]) ; 
    }

  void operator*=(const Matrix4x4 &matrix)
  {
    Vector3D vectTmp;
    for (int j=0;j<3;++j)
      vectTmp[j]=(*this)[0]*matrix[0][j]+(*this)[1]*matrix[1][j]+(*this)[2]*matrix[2][j]+matrix[3][j];
    for (int j=0;j<3;++j)
      (*this)[j]=vectTmp[j];
  }
   
   void operator*=(const double scalaire)
     {
	(*((VectorMaths<double,3>*)this))*=scalaire;
     }

   Vector3D operator* (const double scalaire) {
      Vector3D tmp = *this;
      tmp*=scalaire;
      return tmp;
   }
   Vector3D vectorielle(const Vector3D& v) {
      Vector3D tmp;
      tmp[0]=(*this)[2]*v[0]-(*this)[0]*v[2];
      tmp[1]=(*this)[0]*v[1]-(*this)[1]*v[0];
      tmp[1]=(*this)[1]*v[2]-(*this)[2]*v[1];
      return tmp;
   }
};

#endif



