#ifndef _VECTOR_HPP
#define _VECTOR_HPP

#include <math.h>
#include <assert.h>
#include <iostream>
//#include "Matrix.hpp"

template < typename T, unsigned int SIZE> 
class Vector
{ 
 
 public:
   
   Vector( const Vector<T,SIZE> &v)
     {
	for( unsigned int i = 0 ; i < SIZE ; ++i)
	  Tab[i] = v[i];
     }
   Vector(){}
  
   T operator[]( const unsigned int i) const
    {
       assert( i >= 0 && i < SIZE );
       return Tab[i];
    }
   
   T& operator[]( const unsigned int i)
    {
       assert( i >=0 && i < SIZE );
       return Tab[i];
    }
   
   const T* GetCoords()
     {
	return Tab;
     }
   
 private:
   
   T Tab[SIZE];

};

template< typename T, unsigned int SIZE>
class VectorMath : public Vector< T, SIZE>
{

 public:
 
   VectorMath( const VectorMath<T,SIZE> &v) : Vector< T, SIZE>(v) {}
   
   VectorMath() {}
   
   void operator*=( const T scalaire)
     {
	for( unsigned int i = 0 ; i < SIZE ; ++i)
	  (*this)[i] *= scalaire;
     }
   
   void operator+=( const Vector< T, SIZE> &vecto)
     {
	for( unsigned int i=0 ; i < SIZE ; ++i)
	  (*this)[i] += vecto[i];
     }
   
   VectorMath operator+( const Vector< T,SIZE> &vecto)
     {
	VectorMath res = *this;
	res += vecto;
	return res;
     }
   
   void operator-=( const Vector<T,SIZE> &vecto)
     {
	for( unsigned int i = 0 ; i < SIZE ; ++i)
	  (*this)[i] -= vecto[i];
     }
   
   void fill(T obj)
     {
	for( unsigned int i=0 ; i < SIZE ; ++i)
	  (*this)[i] = obj;
     }
};

/*template< typename T, unsigned int SIZE>
ostream& operator<<( ostream &os,const Vector< T, SIZE> &vect)
{ 
   os << "[" ;
   if( SIZE > 0)
     {
	os << vect[0]; 
	for( unsigned int i=1 ; i < SIZE ; ++i)
	  os << "," <<  vect[i];
     }
   os << "]" << endl;
   return os;
}*/

template < typename T, unsigned int SIZE>
Vector< T, SIZE> operator+( const Vector< T, SIZE>&v1, const Vector< T, SIZE>&v2)
{ 
   VectorMath< T, SIZE> tmpV = v1;
   tmpV += v2;
   return tmpV;
}

template < typename T, unsigned int SIZE>
VectorMath< T, SIZE> operator-( const VectorMath< T, SIZE>&v1, const VectorMath< T, SIZE>&v2)
{ 
   VectorMath< T, SIZE> tmpV = v1;
   tmpV -= v2;
   return tmpV;
}

template < typename T, unsigned int SIZE>
VectorMath<T,SIZE> operator*( const VectorMath< T, SIZE>&v1, const T& scalaire)
{
   VectorMath<T,SIZE> tmpV = v1;
   tmpV *= scalaire;
   return tmpV;
}

template < typename T, unsigned int SIZE>
T operator*( const VectorMath< T, SIZE> &v1, const VectorMath< T, SIZE> &v2)
{
   T tmpO;
   assert(SIZE > 0);
   tmpO = v1[0] * v2[0];
   for ( unsigned int i = 0 ; i < SIZE ; ++i)
     tmpO += v1[i] * v2[i];
   return tmpO;
}

template < typename T, int SIZE>
VectorMath< T, SIZE> operator*( const T &scalaire, const VectorMath< T, SIZE> &v1)
{ 
   return v1 * scalaire;
}


/* === Vector3 implementation ======================================================== */

class Vector3f : public VectorMath< float, 3>
{
  
 public:
 
   Vector3f( const Vector3f &vector) : VectorMath< float, 3>( vector) {}
   
   Vector3f( const VectorMath< float, 3>  &vector) : VectorMath< float, 3>(vector) {}
   
   Vector3f( const float _x=0,const float _y=0,const float _z=0)
    {
      (*this)[0] =_x; (*this)[1] = _y; (*this)[2] = _z;
    }
   
   float normSquared()
     {
	return (*this)[0]*(*this)[0] + (*this)[1]*(*this)[1] + (*this)[2]*(*this)[2]; 
     }

   float norm()
     {
	return sqrtf( normSquared());
     }
   
   void normalize()
     {
	float n = 1.0f / norm();
	
	(*(this))[0] *= n;
	(*(this))[1] *= n;
	(*(this))[2] *= n;
     }
  
   /*
   void operator*=(const Matrix4x4 &matrix)
     {
	Vector3D vectTmp;
	for (int j=0;j<3;++j)
	  vectTmp[j]=(*this)[0]*matrix[0][j]+(*this)[1]*matrix[1][j]+(*this)[2]*matrix[2][j]+matrix[3][j];
	for (int j=0;j<3;++j)
	  (*this)[j]=vectTmp[j];
     }
   
   void operator*=(const double scalaire)
     {
	(*((VectorMath<double,3>*)this))*=scalaire;
     }
   
   Vector3D operator* (const double scalaire) {
      Vector3D tmp = *this;
      tmp*=scalaire;
      return tmp;
   }*/
   
   Vector3f cross( const Vector3f &v) 
     {
	Vector3f tmp;
	tmp[0] = (*this)[2] * v[0] - (*this)[0] * v[2];
	tmp[1] = (*this)[0] * v[1] - (*this)[1] * v[0];
	tmp[1] = (*this)[1] * v[2] - (*this)[2] * v[1];
	return tmp;
     }
   
   float distance( const Vector< float, 3>  &v) 
     {
	return sqrtf( + ( v[0] - (*this)[0] ) * ( v[0] - (*this)[0] ) 
		      + ( v[1] - (*this)[1] ) * ( v[1] - (*this)[1] )
		      + ( v[2] - (*this)[2] ) * ( v[2] - (*this)[2] ) );
     }

};

/* == Point implemantation =========================================================== */

template < typename T, unsigned int SIZE>
class Point : public Vector< T, SIZE>
{
};

class Point3f : public Point< float, 3>
{
};


#endif /* _VECTOR_HPP */
