#ifndef _MATRIXMATHS_HPP
#define _MATRIXMATHS_HPP

#include <assert.h>
#include "VectorMaths.hpp"

template<typename Obj,int SIZE>
class MatrixMaths : public VectorMaths<VectorMaths<Obj,SIZE>,SIZE>
{
  
 public:
  
   void fill(Obj obj)
    {
       for (int i=0;i<SIZE;++i)
	 (*this)[i].fill(obj);
    }
   
   void operator*=(const MatrixMaths<Obj,SIZE> &mat)
     {
	MatrixMaths<Obj,SIZE> tmpMat(*this);
	fill(0);
	for (int i=0;i<SIZE;++i)
	  for (int j=0;j<SIZE;++j)
	    for (int k=0;k<SIZE;++k)
	      (*this)[i][j]+=tmpMat[i][k]*mat[k][j];
     }
};

template<typename Obj,int SIZE>
MatrixMaths<Obj,SIZE> operator*(const MatrixMaths<Obj,SIZE> &mat1,const MatrixMaths<Obj,SIZE> &mat2)
{
   MatrixMaths<Obj,SIZE>tmpMat(mat1);
   tmpMat*=mat2;
   return tmpMat;
}

#endif /* _MATRIX_MATH_HPP */

