#ifndef _MATRIX4_HPP
#define _MATRIX4_HPP

#include <assert.h>
#include "MatrixMaths.hpp"

class Matrix4 : public MatrixMaths<double,4>
{
  public:
  //fonctions membres
  Matrix4(const Matrix4 &v):MatrixMaths<double,4>(v)
    {}
  Matrix4(const MatrixMaths<double,4> &v):MatrixMaths<double,4>(v)
    {}
  Matrix4()
    {}
  void ident()
    {
      for (int i=0;i<4;++i)
	for (int j=0;j<4;++j)
	  (*this)[i][j]=(i==j ? 1 : 0);
    }
  void scale(double sx,double sy,double sz)
    {
      ident();
      (*this)[0][0]=sx;
      (*this)[1][1]=sy;
      (*this)[2][2]=sz;
    }
   void rotX(const double alpha)
    {
      ident();
      double cosAlpha=cos(alpha);
      double sinAlpha=sin(alpha);
      (*this)[1][1]=cosAlpha;
      (*this)[2][2]=cosAlpha;
      (*this)[1][2]=sinAlpha;
      (*this)[2][1]=-sinAlpha;
    }
   void rotZ(const double alpha)
     {
       ident();
       double cosAlpha=cos(alpha);
       double sinAlpha=sin(alpha);
       (*this)[0][0]=cosAlpha;
       (*this)[1][1]=cosAlpha;
       (*this)[0][1]=sinAlpha;
       (*this)[1][0]=-sinAlpha;
    }
   void rotY(const double alpha)
    {
      ident();
      double cosAlpha=cos(alpha);
      double sinAlpha=sin(alpha);
      (*this)[0][0]=cosAlpha;
      (*this)[2][2]=cosAlpha;
      (*this)[0][2]=sinAlpha;
      (*this)[2][0]=-sinAlpha;
    }
};

#endif /* _MATRIX4_HPP */
