#ifndef _GL_STUFF_HPP
#define _GL_STUFF_HPP

//#include "GL/glew.h"
#include "extgl.h"
//#include <SDL_opengl.h>

/* ==== OpenGL extensions loading ========================================= */

extern void gl_load_extensions();


/* ==== OpenGL Garbage ==================================================== */

// -------------------------------------------------------------------------
// A kind of threadsafe garbage for OpenGL objects.
// -------------------------------------------------------------------------
// This garbage can be asked to delete OpenGL objects from 
// a non OpenGL thread. The deletion will be delayed until the system switch
// to the OpenGL thread.
// -------------------------------------------------------------------------

typedef enum GlObjectType
{
     OBJECT_GL_TEXTURE_1D,
     OBJECT_GL_TEXTURE_2D,
     OBJECT_GL_VERTEX_BUFFER_OBJECT
};

// Garbage initialization/Destruction (must be called from the OpenGL thred)

extern void gl_init_garbage(); 

extern void gl_quit_garbage();

// Request to delete an OpenGL object ( can be called in any thread )

extern void gl_plan_destroying( GlObjectType type, GLuint object_id);

// Must be called in OpenGL thread in update loop

extern void gl_clear_garbage();


/* ==== OpenGL Debugging stuff ============================================ */ 

// define check_gl_error as a macro in order to call _check_gl_error
// only when NDEBUG is not defined (like assert)                    

#ifndef NDEBUG

#define check_gl_error(x) _check_gl_error(x)

#else

#define check_gl_error(x) (0)

#endif

extern GLint _check_gl_error( char *str);


/* ==== any basic primitves used to debug ================================= */

extern void gl_draw_repere( float unit);

extern void gl_draw_cube( float unit);


#endif /* GL_STUFF_HPP */
