#include "gl_stuff.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <deque>
#include <SDL.h>
#include <SDL_thread.h>
//#include <SDL_opengl.h>
#ifdef USE_CG
#include <Cg/cg.h>
#endif
#include "config.h"

using namespace std;

void gl_load_extensions()
{

   fprintf( stderr, "Supported extensions:\n%s\n\n", glGetString( GL_EXTENSIONS));
   
//   fprintf( stderr, "extgl_init: %d\n", extgl_Initialize());
}

GLint _check_gl_error( char *str)
{
   GLint error;
   char *error_desc;
   
   if ( (error=glGetError()) != 0 )
     {
	switch( error)
	  {
	   case GL_INVALID_ENUM:      error_desc = "Invalid Enum";      break;
	   case GL_INVALID_VALUE:     error_desc = "Invalid Value";     break;
	   case GL_INVALID_OPERATION: error_desc = "Invalid Operation"; break;
	   case GL_STACK_OVERFLOW:    error_desc = "Stack Overflow";    break;
	   case GL_STACK_UNDERFLOW:   error_desc = "Stack Underflow";   break;
	   case GL_OUT_OF_MEMORY:     error_desc = "Out Of Memory";     break;
	   case GL_TABLE_TOO_LARGE:   error_desc = "Table Too Large";   break;
	   default:                   error_desc = "Unknow error, see gl.h"; break;
	  }
	
	fprintf( stdout, "[01;31min %s\nOpenGL error: 0x%x (%s)[00m\n", str, error, error_desc);
     }  
   return error;
}


/* ==== gl_garbage implemenation ========================================== */

struct GlObject
{
   GlObjectType type;
   GLuint id;
};

struct GlGarbage
{
   deque<GlObject *> queue; 
   SDL_mutex *mutex;
};

GlGarbage glb_gl_garbage;

void gl_init_garbage()
{
   glb_gl_garbage.mutex = SDL_CreateMutex();
}

void gl_plan_destroying( GlObjectType type, GLuint object_id)
{
   GlObject *obj = new GlObject;
   obj->type = type;
   obj->id = object_id;
   
   SDL_mutexP( glb_gl_garbage.mutex);
   glb_gl_garbage.queue.push_back( obj);
   SDL_mutexV( glb_gl_garbage.mutex);
}

void gl_quit_garbage()
{
   SDL_DestroyMutex( glb_gl_garbage.mutex);
}

void gl_clear_garbage()
{
     
   SDL_mutexP( glb_gl_garbage.mutex);
   while( ! glb_gl_garbage.queue.empty())
     {
	GlObject *obj = glb_gl_garbage.queue.front();
	glb_gl_garbage.queue.pop_front();
	
	switch( obj->type)
	  {
	   case OBJECT_GL_TEXTURE_2D:
	     
	     if ( glIsTexture( obj->id))
	       glDeleteTextures( 1, &(obj->id));
	     
#ifdef DEBUG_VERBOSE
	     
	     fprintf( stderr, "gl_garbage: texture %d delted\n", obj->id);
#endif
	     
	     break;
	     
#ifdef USE_VERTEX_BUFFER_OBJECT
	     
	   case OBJECT_GL_VERTEX_BUFFER_OBJECT:
	     
	     glDeleteBuffersARB( 1, &(obj->id));

# ifdef DEBUG_VERBOSE
	     
	     fprintf( stderr, "gl_garbage: buffer object %d delted\n", obj->id);
#endif
	     
	     break;
	     
#endif

	   default: 
	     
	     fprintf( stderr, "gl_garbage: can't delete object of unknown type %d\n", obj->type); 
	  }
	
	delete obj;
     }
   
   SDL_mutexV( glb_gl_garbage.mutex);
}


void gl_draw_repere( float unit)
{
   glBegin( GL_LINES);
   glColor3f( 1.0f, 0.0f, 0.0f); // x is red
   glVertex3f( 0.0f, 0.0f, 0.0f);
   glVertex3f( unit, 0.0f, 0.0f);
   glColor3f( 0.0f, 1.0f, 0.0f); // y is green
   glVertex3f( 0.0f, 0.0f, 0.0f);
   glVertex3f( 0.0f, unit, 0.0f);
   glColor3f( 0.0f, 0.0f, 1.0f); // z is blue
   glVertex3f( 0.0f, 0.0f, 0.0f);
   glVertex3f( 0.0f, 0.0f, unit);	
   glEnd();
}

void gl_draw_cube( float unit)
{
   glColor3f( 1.0f, 1.0f, 1.0f);
   
   // front
   glBegin(GL_LINE_LOOP);
   glVertex3f(-unit, -unit,  -unit);
   glVertex3f( unit, -unit, -unit);
   glVertex3f( unit,  unit, -unit);
   glVertex3f(-unit,  unit, -unit);
   glEnd();
   
   // back
   glBegin(GL_LINE_LOOP);
   glVertex3f(-unit, -unit, unit);
   glVertex3f( unit, -unit, unit);
   glVertex3f( unit,  unit, unit);
   glVertex3f(-unit,  unit, unit);
   glEnd();
   
   // between
   glBegin(GL_LINES);
   glVertex3f(-unit, -unit, -unit);
   glVertex3f(-unit, -unit, +unit);
   glVertex3f(-unit,  unit, -unit);
   glVertex3f(-unit,  unit, +unit);
   glVertex3f( unit,  unit, -unit);
   glVertex3f( unit,  unit, +unit);
   glVertex3f( unit, -unit, -unit);
   glVertex3f( unit, -unit, +unit);
   glEnd();   
}
