#ifndef FRUSTUM_CLASS_DECLARATION
#define FRUSTUM_CLASS_DECLARATION

#define OUTSIDE 0
#define INTERSECTING 1
#define INSIDE 2

// ----------------------------------------------
// Frustum Class: software View Frustum Culling
// using Frame-to-Frame coherence
// Author: Patrick Reuter
// email: preuter@labri.fr
// date: Halloween, 2000
// ----------------------------------------------

class Frustum {
   float _frustum[6][4];
   
   // static Variables
   static int planesOrder[6];			// Exploiting Frame-To-Frame coherence
   
 public:
   // default constructor
   Frustum(void);
   
   // default destructor
   ~Frustum(void);
   
   // Extract the 6 view frustum planes and store them in frustum
   void extractFrustum();
   
   // a function that checks a point against the frustum
   bool pointInFrustum( float x, float y, float z );
   
   // checks if a cube is in the Frustum
   int cubeInFrustum( float x, float y, float z, float size );
   
   // checks if a sphere is in the Frustum
   int sphereInFrustum( float x, float y, float z, float radius );
   
   // checks if an axis aligned Bounding Box is in the frustum
   int AABBInFrustum( float xmin, float xmax, float ymin, float ymax, float zmin, float zmax );

   void Draw();
}; // Frustum Class

#endif

