#ifndef _VIRTUAL_CHUNK_HPP
#define _VIRTUAL_CHUNK_HPP

#include "config.h"
#include "math/Vector.hpp"
#include "projection.hpp"
#include "Node.hpp"

class VirtualChunk
{
 public:
      
   VirtualChunk();
   VirtualChunk( Node node);
   
#ifndef USE_PRECOMPUTED_GRID 
   
   VirtualChunk( Vector3f min, Vector3f max, Node n);

#else /* USE_PRECOMPUTED_GRID not defined */

   VirtualChunk( unsigned int min_gx, unsigned int max_gx, unsigned int min_gy, unsigned int max_gy, Node n);

#endif /* USE_PRECOMPUTED_GRID */

   ~VirtualChunk();  
   
   VirtualChunk GetChild1();
   VirtualChunk GetChild2();
   VirtualChunk GetChild3();
   VirtualChunk GetChild4();

#ifndef USE_PRECOMPUTED_GRID
   
   float xmin;
   float xmax;
   float ymin;
   float ymax;
   float zmin;
   float zmax;
   
#else /* USE_PRECOMPUTED_GRID not defined */
   
   unsigned int min_gx;
   unsigned int max_gx;
   unsigned int min_gy;
   unsigned int max_gy;
   
#endif /* USE_PRECOMPUTED_GRID */
   
   Node node;
   Cube::Face plane_id;
};

#endif /* _VIRTUAL_CHUNK_HPP */
