#include "VirtualChunk.hpp"
#include "config.h"

VirtualChunk::VirtualChunk()
{
}

VirtualChunk::VirtualChunk( Node node)
{
}

#ifndef USE_PRECOMPUTED_GRID

VirtualChunk::VirtualChunk( Vector3f min, Vector3f max, Node n)
{
   xmin=min[0];
   xmax=max[0];
   ymin=min[1];
   ymax=max[1];
   zmin=min[2];
   zmax=max[2];
   node = n;
}

#else
   
VirtualChunk::VirtualChunk( unsigned int min_gx, unsigned int max_gx, unsigned int min_gy, unsigned int max_gy, Node n)
{
   this->min_gx = min_gx;
   this->max_gx = max_gx;
   this->min_gy = min_gy;
   this->max_gy = max_gy;	
   node = n;
   plane_id = node.GetFace();
}

#endif /* USE_PRECOMPUTED_GRID */

VirtualChunk::~VirtualChunk()
{
}
   
VirtualChunk VirtualChunk::GetChild1()
{
   VirtualChunk child;
   
#ifndef USE_PRECOMPUTED_GRID
   
   if ( plane_id == North || plane_id == South)
     {      
	child.xmin = xmin;
	child.xmax = ( xmin + xmax ) / 2.0f;
	child.ymin = ymin;
	child.ymax = ymax;
	child.zmin = zmin;
	child.zmax = ( zmin + zmax ) / 2.0f;
	
     }
	else if ( plane_id == Front || plane_id == Back)
     {
	child.xmin = xmin;
	child.xmax = ( xmin + xmax ) / 2.0f;
	child.ymin = ( ymin + ymax ) / 2.0f;
	child.ymax = ymax;
	child.zmin = zmin;
	child.zmax = zmax;	  
     }
   else // plane_id == West || plane_id == East
     { 
	child.xmin = xmin;
	child.xmax = xmax;
	child.ymin = ( ymin + ymax ) / 2.0f;
	child.ymax = ymax;
	child.zmin = ( zmin + zmax ) / 2.0f;
	child.zmax = zmax;	  	     
     }
   
#else /* USE_PRECOMPUTED_GRID not defined */
   
   child.min_gx = min_gx;
   child.min_gy = min_gy;
   child.max_gx = (min_gx+max_gx)/2;  
   child.max_gy = (min_gy+max_gy)/2;
   
#endif /* USE_PRECOMPUTED_GRID not defined */
   
   child.plane_id = plane_id;
   child.node = node.GetChild(0);
   
   return child;
}

VirtualChunk VirtualChunk::GetChild2()
{
   VirtualChunk child;

#ifndef USE_PRECOMPUTED_GRID
   
   if ( plane_id == North || plane_id == South)
     {      
	child.xmin = ( xmin + xmax ) / 2.0f;
	child.xmax = xmax;
	child.ymin = ymin;
	child.ymax = ymax;
	child.zmin = zmin;
	child.zmax = ( zmin + zmax ) / 2.0f;
     }
   else if ( plane_id == Front || plane_id == Back)
     {
	child.xmin = ( xmin + xmax ) / 2.0f;
	child.xmax = xmax;
	child.ymin = ( ymin + ymax ) / 2.0f;
	child.ymax = ymax;
	child.zmin = zmin;
	child.zmax = zmax;	  
     }
   else // plane_id == West || plane_id == East
     { 
	child.xmin = xmin;
	child.xmax = xmax;
	child.ymin = ( ymin + ymax ) / 2.0f;
	child.ymax = ymax;
	child.zmin = zmin;
	child.zmax = ( zmin + zmax ) / 2.0f;;	  	     
     }

#else /* USE_PRECOMPUTED_GRID not defined */
   
   child.min_gx = (min_gx+max_gx)/2;
   child.min_gy = min_gy;
   child.max_gx = max_gx;;  
   child.max_gy = (min_gy+max_gy)/2;

#endif /* USE_PRECOMPUTED_GRID not defined */

   child.plane_id = plane_id;
   child.node = node.GetChild(1);
   
   return child;
}

VirtualChunk VirtualChunk::GetChild3()
{
   VirtualChunk child;
   
#ifndef USE_PRECOMPUTED_GRID
   
   if ( plane_id == North || plane_id == South)
     {      
	child.xmin = xmin;
	child.xmax = ( xmin + xmax ) / 2.0f;
	child.ymin = ymin;
	child.ymax = ymax;
	child.zmin = ( zmin + zmax ) / 2.0f;
	child.zmax = zmax;
     }
   else if ( plane_id == Front || plane_id == Back)
     {
	child.xmin = xmin;
	child.xmax = ( xmin + xmax ) / 2.0f;
	child.ymin = ymin;
	child.ymax = ( ymin + ymax ) / 2.0f;
	child.zmin = zmin;
	child.zmax = zmax;	  
     }
   else // plane_id == West || plane_id == East
     { 
	child.xmin = xmin;
	child.xmax = xmax;
	child.ymin = ymin;
	child.ymax = ( ymin + ymax ) / 2.0f;
	child.zmin = ( zmin + zmax ) / 2.0f;
	child.zmax = zmax;
     }
   
#else /* USE_PRECOMPUTED_GRID not defined */

   child.min_gx = min_gx;
   child.min_gy = (min_gy+max_gy)/2;
   child.max_gx = (min_gx+max_gx)/2;  
   child.max_gy = max_gy;
   
#endif /* USE_PRECOMPUTED_GRID not defined */
   
   child.plane_id = plane_id;	
   child.node = node.GetChild(2);
   
   return child;
}

VirtualChunk VirtualChunk::GetChild4()
{
   VirtualChunk child;
   
#ifndef USE_PRECOMPUTED_GRID
   
   if ( plane_id == North || plane_id == South)
     {      
	child.xmin = ( xmin + xmax ) / 2.0f;
	child.xmax = xmax;
	child.ymin = ymin;
	child.ymax = ymax;
	child.zmin = ( zmin + zmax ) / 2.0f;
	child.zmax = zmax;
     }
   else if ( plane_id == Front || plane_id == Back)
     {
	child.xmin = ( xmin + xmax ) / 2.0f;
	child.xmax = xmax;
	child.ymin = ymin;
	child.ymax = ( ymin + ymax ) / 2.0f;
	child.zmin = zmin;
	child.zmax = zmax;	  
     }
   else // plane_id == West || plane_id == East
     { 
	child.xmin = xmin;
	child.xmax = xmax;
	child.ymin = ymin;
	child.ymax = ( ymin + ymax ) / 2.0f;
	child.zmin = zmin;
	child.zmax = ( zmin + zmax ) / 2.0f;
     }
   
#else /* USE_PRECOMPUTED_GRID not defined */

   child.min_gx = (min_gx+max_gx)/2;
   child.min_gy = (min_gy+max_gy)/2;
   child.max_gx = max_gx;
   child.max_gy = max_gy;

#endif /* USE_PRECOMPUTED_GRID not defined */
   
   child.plane_id = plane_id;   
   child.node = node.GetChild(3);
   
   return child;
}
