#ifndef _VECT_OBJECTS_HPP
#define _VECT_OBJECTS_HPP

#include <vector>
#include <string>
#include <fstream>
#include "math/Vector.hpp"
#include "projection.hpp"

using namespace std;

struct SDL_RWops;

class VectObject
{
 public:
   VectObject() {};
   virtual ~VectObject() {};   
   
   virtual void LoadASCII( ifstream *r_stream)=0;
   virtual void LoadBinary( SDL_RWops *r_ops)=0;   
   virtual void SaveASCII( ofstream *w_stream)=0;
   virtual void SaveBinary( SDL_RWops *w_ops)=0;
  
   virtual void glDraw() = 0;
};

class VO_Point : public VectObject
{
 public:
   VO_Point() {};
   VO_Point( float lat_deg, float lon_deg, float radius=RADIUS);
   ~VO_Point();
   
   void LoadASCII( ifstream *r_stream);
   void LoadBinary( SDL_RWops *r_ops);   
   void SaveASCII( ofstream *w_stream);
   void SaveBinary( SDL_RWops *w_ops);
  
   void glDraw();
   
// private:
   Vector3f coord;
   Cube::Coord cube_coord;
   float lat_deg;
   float lon_deg;
};

class VO_PolyLine : public VectObject
{
 public: 
   VO_PolyLine() {};
   virtual ~VO_PolyLine();
   
   void LoadASCII( ifstream *r_stream);
   void LoadBinary( SDL_RWops *r_ops);   
   void SaveASCII( ofstream *w_stream);
   void SaveBinary( SDL_RWops *w_ops);

   void AddPoint( VO_Point point);
   void glDraw();
   VO_PolyLine *Resample( float precision);

   unsigned int getNbPoints() { return points.size();}
   
   // private:
   vector< VO_Point> points;
};

class VO_PolyPolyLine : public VectObject
{
 public:
   VO_PolyPolyLine();
   virtual ~VO_PolyPolyLine();
   
   void LoadASCII( ifstream *r_stream);
   void LoadBinary( SDL_RWops *r_ops);
   void SaveASCII( ofstream *w_stream);
   void SaveBinary( SDL_RWops *w_ops);

   void AddPolyLine( VO_PolyLine *polyline);
   
   unsigned int getNbPoints() 
     { 
	unsigned int nb_points = 0;
	for( unsigned int l = 0 ; l < lines.size(); l++)
	  nb_points += lines[l]->getNbPoints();
	return nb_points;
     }
   
   unsigned int getNbLines() { return lines.size();}

   /////////////////////////////
   bool LoadFromTxtFile( string filename);
   bool LoadFromBinFile( string filename);
   bool SaveToTxtFile( string filename);
   bool SaveToBinFile( string filename);
   bool SaveToBinRWops( SDL_RWops *w_ops);
   /////////////////////////////
   
   void glDraw();

   VO_PolyPolyLine *Resample( float precision);
   
   vector< VO_PolyLine *> lines;
};
  
#endif /* _VECT_OBJECTS_HPP */
