#ifndef _VECT_INFOS_HPP
#define _VECT_INFOS_HPP

#include <string>
#include <vector>
#include <map>
#include <fstream>
#include "VectObjects.hpp"

#define BOUNDARIES_COLOR 0.6f,0.6f,0.0f
#define COASTLINES_COLOR 0.0f,0.0f,0.8f
#define RIVERS_COLOR     0.0f,0.0f,0.5f

using namespace std;

class VectObject;
struct SDL_RWops;

// Controler // static un seul -> Singleton

struct VectProperty
{
   VectProperty();
   VectProperty( string name, string value) { this->name = name; this->string_value = value;}
   ~VectProperty();
   
   void LoadBinary( SDL_RWops *r_ops);
   void SaveBinary( SDL_RWops *w_ops);
   
   unsigned int type_magic;
   string name;
   string string_value;
   unsigned int uint32_value;
};

class VectProperties
{
 public:
   VectProperties() {}
   ~VectProperties() {}
   
   void LoadBinary( SDL_RWops *r_ops);
   void SaveBinary( SDL_RWops *w_ops);   
   
   void Add( string property_name, VectProperty *property);
   void Remove( string property_name);

   bool HaveString( string property_name, string *property_value);

   map< string, VectProperty *> properties;
};

class VectInfo
{
 public:
   VectInfo();
   VectInfo( VectObject *vo, VectProperties *vp, string type, string name);
   ~VectInfo();

   void LoadASCII( ifstream *r_stream);
   void LoadBinary( SDL_RWops *r_ops);
   void SaveASCII( ofstream *w_stream);
   void SaveBinary( SDL_RWops *w_ops);

   void Render();
   
   string GetType() { return type;}
   string GetName() { return name;} 
   VectObject * GetVectObject() { return vo;}
   VectProperties *GetVectProperties() { return vp;}
 
 private:
   void CreateVectObject( string type);

   string type; // VO_Point, VO_Line, VO_PolyLine, VO_Polygon...
   string name; // Boundary, Coastline, City...
   VectProperties *vp; // map of Label Symbol, Url...
   VectObject *vo;
};

class VectInfoCollection
{
 public:
   VectInfoCollection();
   ~VectInfoCollection();

   void LoadASCII( ifstream *r_stream);
   void LoadBinary( SDL_RWops *r_ops);
   void SaveASCII( ofstream *w_stream);
   void SaveBinary( SDL_RWops *w_ops);

   void AddVectInfo( VectInfo *vi);
   void RemoveVectInfo( string);

   vector< string> GetAllTypes();
   void SelectType( string type, bool select);
   
   void Render();
   
 private:
   //map< string, map< string, VectInfo> > collection;
   vector< VectInfo*> collection; 
};


#endif /* _VECT_INDOS_HPP */
