#ifndef _TEXTURE_ARRAY_HPP
#define _TEXTURE_ARRAY_HPP

#include <deque>
#include "gl_stuff.hpp"

using namespace std;

struct TextureID
{
   GLint id;
};

struct TextureSetup
{
   // number of lod
   GLuint nb_lod;
   // modulate
      
   // parameters for glTexImage2D
   GLenum target;
   GLint level;
   GLint internalFormat;
   GLsizei width;
   GLsizei height;
   GLint border;
   GLenum format;
   GLenum type;
};

class TextureArray
{
 public:
   TextureArray();
   ~TextureArray();
   
   bool Allocate( unsigned int nb_textures, TextureSetup texture_setup);
   void FreeArray();
   
   TextureID TakeTexture();
   void ReleaseTexture( TextureID texture_id);
   
   bool BindTexture( TextureID texture_id);
   
 private:
   unsigned int array_size;
   GLuint *entries;
   bool *entries_state;
   TextureSetup texture_setup;
};

#endif /* _TEXTURE_ARRAY_HPP */
