#ifndef _PLANET_HPP
#define _PLANET_HPP

#include <vector>
#include "math/Vector.hpp"
#include "Grid.hpp"
#include "DataSet.hpp"
#include "VirtualChunk.hpp"

using namespace std;

class Cache;
class Camera;
class Chunk;

class Planet
{
 public:
   Planet();
   ~Planet(); 
   
   void Initialize( string filename);
   void Draw( Camera *camera);
   
   void DrawMeridian( float lon_deg, float step_deg=1.0f);
   void DrawLatitude( float lat_degn, float step_deg=1.0f);

   void PickCoordinates( int screen_x, int screen_y, float *lat_deg, float *lon_deg);

   unsigned int GetDrawnNodes();
   unsigned int GetExploredNodes();
   
   void DrawGrids();

   ////////
   void FillChunkGeometry( Chunk *chunk);
   const DataSet * GetDataSet() { return &ds;}
   VirtualChunk GetVirtualChunk( Node node);
   
 private:
   void LoadSetup();
   void ComputeGrids();
   void DrawSurface( VirtualChunk *vchunk, Camera *camera);
   float ComputeVirtualChunkScreenSize( VirtualChunk *vchunk, Camera *camera);
   float GetSurfaceProjectedScreenSize( VirtualChunk *vchunk);
   void DrawChunk( VirtualChunk *vchunk, float normalized_screen_space=0.0f);
   void DrawChunkOcean( VirtualChunk *vchunk);
   float GetDistance( VirtualChunk *vchunk, Camera *camera);
   Cache *cache;
   DataSet ds;
   Grid< Vector3f> *grids;
   Grid< Vector3f> *normals_grids;
   
   // Setup
   unsigned int nb_lod;
   unsigned int grid_width;
   unsigned int textures_width;
   float radius;
   unsigned int dataset_version;
   
   // Statistics
   unsigned int drawn_nodes_counter;
   unsigned int explored_nodes_counter;
};

#endif /* _PLANET_HPP */
