#ifndef _OPTIONS_HPP
#define _OPTIONS_HPP

#include "config.h"

struct Options
{
   bool lighting;
   bool bump_mapping;
   bool frustum_culling;
   bool backface_culling;
   
   bool draw_coastlines;
   bool draw_boundaries;
   bool draw_rivers;
   bool draw_cities;
   
   bool draw_latitudes;
   bool draw_longitudes;
   bool draw_clouds;
   bool lock_camera_orientation;
   bool statistics;
   float threshold;
   float visibility_m;    

   float fov_deg;
   unsigned int screen_width;
   unsigned int screen_height;
   
#ifdef _DEBUG
   
   bool subdivisions;
   bool bounding_box;
   bool wireframe;
   bool draw_rep;
   bool draw_cube;
   bool camera_locked;
   bool debug_vecto;
   
#endif /* _DEBUG */
  
   Options()
     {
	lighting = false;
	bump_mapping = true;
	frustum_culling = false;
	backface_culling = false;
	draw_coastlines = false;
	draw_boundaries = false;
	draw_rivers = false;
	draw_cities = true;
	draw_clouds = false;
	draw_latitudes = false;
	draw_longitudes = false;
	lock_camera_orientation = false;
	statistics =false;
	threshold = 50.0f;	
	visibility_m = 300000; 
	fov_deg = DEFAULT_FOV_DEG;
	screen_width = DEFAULT_SCREEN_WIDTH;
	screen_height = DEFAULT_SCREEN_HEIGHT;
	
#ifdef _DEBUG
	
	subdivisions = false;
	bounding_box = false;
	wireframe = false;
	draw_rep = false;
	draw_cube = false;
	camera_locked = false;
	debug_vecto = false;
	
#endif /* _DEBUG */     
	
     }
};

extern Options options;

#endif /* _OPTIONS_HPP */
