#include <stdlib.h>
#include <stdio.h>
#include "Node.hpp"

Node::Node( const unsigned long node, Cube::Face face)
{
   // 1) compute depth of this node
   level = 0;
   unsigned long nb_nodes_before = 0 ;
   while( nb_nodes_before+(1<<(2*level)) <= node ) 
     {
	nb_nodes_before += (1<<(2*level));
	level++;
     }
   
   // 2) compute posx,posy of this node
   long width_of_this_level = 1 << level;
   unsigned long nb_nodes_before_this_level = 0x55555555 & ( 1 << (level*2) ) - 1 ;
   x = ( node - nb_nodes_before_this_level ) % width_of_this_level;
   z = ( node - nb_nodes_before_this_level ) / width_of_this_level; 
   node_number = node;
   this->face=face;
}

/*unsigned long Node::GetChild16( long dx, long dz) const
{
   // compute width of this level
   long width_of_child_level = 1 << (level+1);

   if ( (long)x*2+dx < 0 || (long)x*2+dx >= width_of_child_level ||
	(long)z*2+dz < 0 || (long)z*2+dz >= width_of_child_level)
     return 0;
   else
     return Node( level+1, x*2+dx, z*2+dz).GetNumber();
}*/

string *Node::GetID( const string &prefix) const
{
   char num[1024];
   string *name = new string;
   
   sprintf( num, "%05d", GetNumber());
   
   *name += string(prefix) + string(num);
   return name;
}

