#include <SDL.h>
#include <SDL_opengl.h>
#include <aedGui.h>
#include "GlGui.hpp"

#include "aedXmlFile.h"
#include "font.h"

#define MINIMAL_TEXTURE_WIDTH 64


GlGui::GlGui( unsigned int width, unsigned int height, float x) : aedWidget( width, height, false)
{      
   setPos( 600, 0);
   m_PositionOffset = aedRect( 600, 0, 800, 600),
   CreateTexture( width, height);   
}

GlGui::~GlGui()
{
}

void GlGui::CreateTexture( unsigned int width, unsigned int height) 
{
   
   /*
    This Function creates our GUI Texture, notice that due
    to the OpenGL limitation of powers of 2 for textures sides,
    we must create a texture with side width equal to 128, 256, 1204.. pixels.
    */ 

   this->width = width;
   this->height = height;
   
   texture_width = MINIMAL_TEXTURE_WIDTH;
   while( texture_width < width)
     texture_width *= 2;
   
   texture_height = MINIMAL_TEXTURE_WIDTH;
   while( texture_height < height)
     texture_height *= 2;

#ifdef _DEBUG
   
   fprintf( stderr, "GlGui: requested dimension %d x %d\n", width, height);
   fprintf( stderr, "GlGui: texture dimension is %d x %d\n", texture_width, texture_height);
   
#endif /* _DEBUG */
	   
   // 1) Create main memory texture cache
 
   Uint32 rmask, gmask, bmask, amask;
   
   /* 
    SDL interprets each pixel as a 32-bit number, so our masks must depend
    on the endianness (byte order) of the machine 
    */
   
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
   rmask = 0xff000000;
   gmask = 0x00ff0000;
   bmask = 0x0000ff00;
   amask = 0x000000ff;
#else 
   rmask = 0x000000ff;
   gmask = 0x0000ff00;
   bmask = 0x00ff0000;
   amask = 0xff000000;
#endif
   
   SDL_Surface *s = SDL_GetVideoSurface();   
   
   screen = SDL_CreateRGBSurface( SDL_SWSURFACE, s->w, s->h, 32, rmask, gmask, bmask, amask);
   if( texture == NULL)
     {
        fprintf(stderr, "GlGui: CreateRGBSurface failed: %s\n", SDL_GetError());
     }
  
   Uint32 *pixel = (Uint32 *) screen->pixels;
   for(int i = 0; i < screen->w * screen->h; i++)
     {
        pixel[i] = amask;
     } 
   
   // 2) Create OpenGL Texture
 
   texture = SDL_CreateRGBSurface( SDL_SWSURFACE, width, height, 32, rmask, gmask, bmask, amask);
   if( texture == NULL)
     {
        fprintf(stderr, "GlGui: CreateRGBSurface failed: %s\n", SDL_GetError());
     }
   
   pixel = (Uint32 *) texture->pixels;
   for(int i = 0; i < texture->w * texture->h; i++)
     {
        pixel[i] = amask;
     } 
      
   glGenTextures( 1, &texture_id);
   glBindTexture( GL_TEXTURE_2D, texture_id);
   
   glTexImage2D( GL_TEXTURE_2D, 0, 4, texture_width, texture_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);
   
   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
};

void GlGui::Update()
{
   update();
}


void GlGui::Draw() 
{
   static int refresh_time = 0;
   
   if ( refresh_time++ > 10)
     {
	refresh_time = 0;
	
	// should test if needed 
	renderAll( screen);
	
 	SDL_Rect screen_rect = { 600, 0, 200, 600};
	SDL_Rect texture_rect = { 0, 0, 200, 600};
	
	if ( SDL_BlitSurface( screen, &screen_rect, texture, NULL) != 0 )
	  fprintf( stderr, "GlGui: Blit failed\n");;
	
	//SDL_SaveBMP( screen , "screen.bmp"),
	//SDL_SaveBMP( texture , "texture.bmp"),
	
	glBindTexture(GL_TEXTURE_2D, texture_id);
   
	glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, texture->w, texture->h, GL_RGBA, GL_UNSIGNED_BYTE, texture->pixels);
	
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	
     }
   
   // then render
   
   glMatrixMode(GL_PROJECTION);
   glPushMatrix();
   glLoadIdentity();
   glOrtho( 0, 800, 0, 600, 0, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   
   glBlendFunc( GL_SRC_ALPHA, GL_ONE);
   glEnable( GL_BLEND);
   glEnable( GL_TEXTURE_2D);
   glColor4f( 1.0f, 1.0f, 1.0f, 1.0f);
   glBindTexture(GL_TEXTURE_2D, texture_id);
   
   float sw = (float)width/(float)texture_width;
   float sh = (float)height/(float)texture_height;
      
   glBegin(GL_QUADS);
   glTexCoord2f( 0.0f, 0.0f);
   glVertex2f( 600, 600); 
   glTexCoord2f( 0.0f, sh);
   glVertex2f( 600, 0);
   glTexCoord2f( sw, sh);
   glVertex2f( 800, 0);
   glTexCoord2f( sw, 0.0f);
   glVertex2f( 800, 600);
   glEnd();
   glMatrixMode(GL_PROJECTION);
   glPopMatrix();
   glMatrixMode(GL_MODELVIEW);
}
