#ifndef _FLAGS_TABLE_HPP
#define _FLAGS_TABLE_HPP

#include <string>
#include <vector>
#include <map>
using namespace std;
class Texture;

class FlagsTable
{
 public:
   FlagsTable();
   ~FlagsTable();

   enum Corner
     {
	UP_LEFT,
	UP_RIGHT,
	DOWN_LEFT,
	DOWN_RIGHT
     };
   
   unsigned int GetFlagNo( string country);
   void GlBind();
   void SetGlTexCoord( unsigned int flag_no, Corner corner);
   
 private:
   Texture *table;
   int flag_width;
   int flag_height;
   int nb_flags_in_width;
   int nb_flags_in_height;
   vector< string> countries;
};

#endif /* _FLAGS_TABLE_HPP */
