#include <stdlib.h>
#include <stdio.h>
#include "gl_stuff.hpp"
#include "Texture.hpp"
#include "FlagsTable.hpp"

FlagsTable::FlagsTable()
{
   table = new Texture();
   
   table->LoadImage( "flags.png");

   flag_width = 60;
   flag_height = 36;
   nb_flags_in_width = 17;
   nb_flags_in_height = 14;
  
   FILE* fdf = fopen( "flags.txt", "r");
   if ( fdf == NULL )
     {
	fprintf( stderr, "FlagsTable: can't open flags definition file %s\n", "flags.txt");
	return;
     }

   int line_no=0;
   
   while( ! feof( fdf))
     {
	char line[1024];
	char country[1024];
	
	fgets( line, 1024, fdf);
	
	line_no++;
	
	if ( line[0] == '#')
	  continue;
	
	if ( sscanf( line, "\"%[^\"]", country) == 1 ) 
	  countries.push_back( country);
	else
	  fprintf( stderr, "FlagsTable: parse error line %d: %s\n", line_no, line);
     }

   fclose( fdf);
}
  
FlagsTable::~FlagsTable()
{
}

unsigned int FlagsTable::GetFlagNo( string country)
{
   for( unsigned int flag_no=0 ; flag_no < countries.size(); flag_no++)
     if( countries[flag_no] == country)
       return flag_no;
   
   return 0;
}

void FlagsTable::GlBind()
{
   table->Bind();
}

  
void FlagsTable::SetGlTexCoord( unsigned int flag_no, Corner corner)
{
   float px = flag_width  * ( flag_no % nb_flags_in_width) + (( corner == UP_RIGHT || corner == DOWN_RIGHT)? flag_width : 0);
   float py = flag_height * ( flag_no / nb_flags_in_width) + (( corner == DOWN_LEFT || corner == DOWN_RIGHT ) ? flag_height : 0);

   glTexCoord2f( px/1024.0f, py/512.0f);
   
}
