#include "Texture.hpp"
#include "gl_stuff.hpp"
#include "projection.hpp"
#include "CloudsLayer.hpp"

CloudsLayer::CloudsLayer()
{
   texture = NULL;
   display_list_initialized = false;
   
   texture = new Texture;
   texture->LoadImage( "clouds_2048.jpg");
}

CloudsLayer::~CloudsLayer()
{
   if ( texture)
     delete texture;
}

void CloudsLayer::Draw()
{
   glBlendFunc( GL_SRC_ALPHA, GL_ONE);
   glEnable( GL_BLEND);
   glEnable( GL_TEXTURE_2D);
   texture->Bind();
   
   if ( !display_list_initialized )
     {
	display_list = glGenLists( 1);
	
	glNewList( display_list, GL_COMPILE);
	
	glBegin( GL_QUADS);
	glColor4f( 0.9f, 0.9f, 0.9f, 0.9f);
	
	for( float lat_deg = 0.0f ; lat_deg < 180.0f ; lat_deg +=5.0f)
	  for( float lon_deg = 0.0f ; lon_deg < 360.0f ; lon_deg += 5.0f)
	    {
	       glTexCoord2f( lon_deg/360.0f, lat_deg/180.0f);
	       glNormal3fv( PolarToCoord3D( (float)lat_deg-90.0f,       (float)lon_deg-180.0f, RADIUS+0.001).c);
	       glVertex3fv(PolarToCoord3D( (float)lat_deg-90.0f,       (float)lon_deg-180.0f, RADIUS+0.001).c);
	
	       glTexCoord2f( lon_deg/360.0f, (lat_deg+5.0f)/180.0f);
	       glNormal3fv(PolarToCoord3D( (float)lat_deg-90.0f+5.0f,  (float)lon_deg-180.0f, RADIUS+0.001).c);	
	       glVertex3fv(PolarToCoord3D( (float)lat_deg-90.0f+5.0f,  (float)lon_deg-180.0f, RADIUS+0.001).c);	
	       
	       glTexCoord2f( (lon_deg+5.0f)/360.0f, (lat_deg+5.0f)/180.0f);
	       glNormal3fv(PolarToCoord3D( (float)lat_deg-90.0f+5.0f,  (float)lon_deg-180.0f+5.0f, RADIUS+0.001).c);
	       glVertex3fv(PolarToCoord3D( (float)lat_deg-90.0f+5.0f,  (float)lon_deg-180.0f+5.0f, RADIUS+0.001).c);
	       
	       glTexCoord2f( (lon_deg+5.0f)/360.0f, lat_deg/180.0f);
	       glNormal3fv(PolarToCoord3D( (float)lat_deg-90.0f,       (float)lon_deg-180.0f+5.0f, RADIUS+0.001).c);		  
	       glVertex3fv(PolarToCoord3D( (float)lat_deg-90.0f,       (float)lon_deg-180.0f+5.0f, RADIUS+0.001).c);		  
	    }
	
	glEnd();     
        
	glEndList();
	
	display_list_initialized = true;
     }
   else
     {  
	glCallList( display_list );
     }

   glDisable( GL_TEXTURE_2D);
   glDisable( GL_BLEND);   
}

