#ifndef _CITIES_HPP
#define _CITIES_HPP

#include <vector>
#include <string>
#include "math/Vector.hpp"
#include "VectInfos.hpp"

using namespace std;

class Camera;
class FTFont;
class FlagsTable;

struct City
{
   float latitude_deg;
   float longitude_deg;
   Vector3f position;
   
   bool is_capital;
   unsigned int population;
   string name;
   string country;
   unsigned int flag_id;
};

class Cities
{
 public:
   Cities();
   ~Cities();

   void LoadFromText( string filename);
   void Draw( Camera *camera);
 
 private:
   vector< City> cities; 
   bool display_list_initialized;
   GLuint display_list;
   FTFont* font;
   FTFont* font2;
   FlagsTable *flags_table;
   vector <VectInfo *> *pof;
};

#endif /* _CITIES */
