#include <iostream>
#include <string>
#include <math.h>
#include <SDL.h>
#include <stdlib.h>
#include <stdio.h>
#include "gl_stuff.hpp"
#include <FTGL/FTGLExtrdFont.h>
#include <FTGL/FTGLOutlineFont.h>
#include <FTGL/FTGLPolygonFont.h>
#include <FTGL/FTGLTextureFont.h>
#include <FTGL/FTGLPixmapFont.h>
#include <FTGL/FTGLBitmapFont.h>

#include "config.h"
#include "math/Vector.hpp"
#include "projection.hpp"
#include "Camera.hpp"
#include "FlagsTable.hpp"
#include "Cities.hpp"

#ifndef _WIN32

vector <VectInfo *> * load_pof( string filename)
{
   FILE *f;
   char *full_line = new char[2048+1];
   vector <VectInfo *> *vect_infos = new vector <VectInfo *>;
  
   f = fopen( filename.c_str(), "r");
   
   if ( f == NULL )
     {
	fprintf( stderr, "load_cities: can't open file %s for reading\n", filename.c_str());
	exit( EXIT_FAILURE);
     }
   
   while( !feof( f) && vect_infos->size() < 10000)
     {
	char *line = full_line;
	
	fgets( line, 2048, f);
	
	if ( line[0] != '#')
	  {
	     int RC; // Region code
	     int UFI; // Unique Future Identifier 
	     int UNI; // Unique Name Identifier
	     float LAT; // Latitude (deg)
	     float LONG; // Longitude (deg)
	     char DMS_LAT[64]; // WGS84 style latitude ( deg, min, sec)
	     char DMS_LONG[64]; // WGS84 style longitude ( deg, min, sec)
	     char UTM[4+1]; // Universal Transverse Mercato
	     char JOG[7+1]; // Joint Operations Graphic
	     char FC; // Feature Classification
	     char DSG[5+1]; // Feature Designation Code
	     //int PC; // Populated Place Classification
	     char PC[64]; // AGAINST WHAT IS WRITTEN IN REFERENCE 
	     char PCC[2+1]; // Primary Country Code
	     char ADM1[2+1]; // First-order administrative division
	     char ADM2[200+1]; // Second-order administrative division
	     int DIM; // Dimension
	     char CC2[2+1]; //Secondary Country Code
	     char NT; // Name Type
	     char LC[2+1]; // Language Code
	     char SHORT_FORM[128+1]; 
	     char GENERIC[128+1];
	     char SORT_NAME[200+1];
	     char FULL_NAME[200+1];
	     char FULL_NAME_ND[200+1];
	     char MOD_DATE[10+1];
	     
	     int nb_items;
	     
	     char *item;	     
	     
	     item = strsep( &line, "\t");
	     RC = item ? atoi( item) : 0;
	     item = strsep( &line, "\t");
	     UFI = item ? atoi( item) : 0; 
	     item = strsep( &line, "\t");
	     UNI = item ? atoi( item) : 0;
	     item = strsep( &line, "\t");
	     LAT = item ? atof( item) : 0.0f;
	     item = strsep( &line, "\t");
	     LONG = item ? atof( item) : 0.0f;
	     item = strsep( &line, "\t");
	     strncpy( DMS_LAT, item ? item : "", 64);
	     item = strsep( &line, "\t");
	     strncpy( DMS_LONG, item ? item : "", 64); 
	     item = strsep( &line, "\t");
	     strncpy( UTM, item ? item : "", 4); 
	     item = strsep( &line, "\t");
	     strncpy( JOG, item ? item : "", 7);   
	     item = strsep( &line, "\t"); 
	     FC = item ? item[0] : '?';
	     item = strsep( &line, "\t");
	     strncpy( DSG, item ? item : "", 5);
	     item = strsep( &line, "\t");
	     strncpy( PC, item ? item : "", 64); // AGAINST WHAT IS WRITTEN IN REFERENCE 
	     item = strsep( &line, "\t");
	     strncpy( PCC, item ? item : "", 2);
	     item = strsep( &line, "\t");
	     strncpy( ADM1, item ? item : "", 2);
	     item = strsep( &line, "\t");
	     strncpy( ADM2, item ? item : "", 200);
	     item = strsep( &line, "\t");
	     DIM = item ? atoi( item) : 0;
	     item = strsep( &line, "\t");
	     strncpy( CC2, item ? item : "", 2);
	     item = strsep( &line, "\t");
	     //NT = item[0]; //IGNORE
	     item = strsep( &line, "\t");
	     strncpy( LC, item ? item : "", 2);
	     item = strsep( &line, "\t");
	     strncpy( SHORT_FORM, item ? item : "", 28);
	     item = strsep( &line, "\t");
	     strncpy( GENERIC, item ? item : "", 200);
	     item = strsep( &line, "\t");
	     strncpy( SORT_NAME, item ? item : "", 200);
	     item = strsep( &line, "\t");
	     strncpy( FULL_NAME, item ? item : "", 200);
	     item = strsep( &line, "\t");
	     strncpy( FULL_NAME_ND, item ? item : "", 200);
	     item = strsep( &line, "\t");
	     strncpy( MOD_DATE, item ? item : "", 10);
	     item = strsep( &line, "\t");

	     if  ( FC == 'U')
	       {
		 fprintf( stdout, "[ %f %f ] %s ( %c  -> %s)\n", LAT, LONG, FULL_NAME_ND, FC, PC);
	     
		  VectObject *vo = new VO_Point( LAT, LONG);
		  VectProperties *vp = new VectProperties();
		  
		  vp->Add( "label", new VectProperty( "label", FULL_NAME_ND));
		  //if ( capital_flag == 'Y')
		  //  vp->AddString( "Flag" , country); 
		 
		  //city.population = population;
		  //city.flag_id = flags_table->GetFlagNo( country);
	
		  VectInfo *vi = new VectInfo( vo, vp, "VO_POINT", "Cities");
		    
		  vect_infos->push_back( vi);
	       }
	  }	
     }
   
   fclose( f);
   
   fprintf( stderr, "%d pof loaded\n", vect_infos->size());

   return vect_infos;
}


#endif

Cities::Cities()
{
   // open fonts
   
   font = new FTGLTextureFont( "arial.ttf");
      
   if( !font->FaceSize( 64))
     {
	fprintf( stderr, "Display_Gl::Initialize: failed to set size\n");
	return;
     }

   //font->Depth(2);

      font2 = new FTGLPolygonFont( "arial.ttf");
      
   if( !font2->FaceSize( 32))
     {
	fprintf( stderr, "Display_Gl::Initialize: failed to set size\n");
	return;
     }

   flags_table = new FlagsTable();

   LoadFromText( "world_cities.txt");

//   pof = load_pof( "world_pof.txt");

}

Cities::~Cities()
{
   delete font;
}

void Cities::LoadFromText( string filename)
{
   FILE *f;
   char line[1024];
   
   f = fopen( filename.c_str(), "r");
   
   if ( f == NULL )
     {
	fprintf( stderr, "Cities: can't open file %s for reading\n", filename.c_str());
	return;
     }
  
   while( !feof( f))
     {
	fgets( line, 1024, f);
	
	if ( line[0] != '#')
	  {
	     int lon_deg, lon_min, lat_deg, lat_min;
	     char lat_sign, lon_sign, capital_flag;
	     unsigned int population = 0;
	     char city_name[1024], country[1024];   
	      
	     City city;
	     
	     if ( sscanf( line, "\"%[^\"]\" %d %d %c %d %d %c %c \"%[^\"]\" %d", 
		     city_name, 
		     &lat_deg, &lat_min, &lat_sign,
		     &lon_deg, &lon_min, &lon_sign, &capital_flag, country, &population) > 8 ) 
	       {
		  
		  city.name = city_name;
		  city.latitude_deg  = ( ((float) lat_deg) + ((float) lat_min) / 60.0f ) * ((lat_sign=='N')?1.0f:-1.0f);
		  city.longitude_deg = ( ((float) lon_deg) + ((float) lon_min) / 60.0f ) * ((lon_sign=='E')?1.0f:-1.0f);
		  city.position = PolarToCoord3f( city.latitude_deg, city.longitude_deg, 0.5f);
		  city.is_capital = ( capital_flag == 'Y');
		  city.population = population;
		  city.country = country;
		  city.flag_id = flags_table->GetFlagNo( country);
		  
		  cities.push_back( city);
	       }
	  }	
     }
   
   fclose( f);

   fprintf( stderr, "cities loaded\n");
}


void Cities::Draw( Camera *camera)
{
   glPointSize( 5.0f);
   glEnable( GL_POINT_SMOOTH);
   
   glColor3f( 1.0f, 0.0f, 0.0f);
   
/*   glBegin( GL_POINTS);
   
   for( unsigned int i=0;i<cities.size();i++)
     {
	
	//glPointSize( ((float)(cities[i].population))/1000000.0f);
	
	//glBegin( GL_POINTS);
 
	glVertex3fv( cities[i].position.GetCoords());
     
     }
   
   glEnd();
  */   
   
   //	glShadeModel( GL_SMOOTH);
   //	glDisable( GL_DEPTH_TEST);
   glEnable( GL_BLEND);
   glBlendFunc( GL_SRC_ALPHA, GL_ONE);
   glEnable( GL_TEXTURE_2D);
   //	glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
   //	glHint( GL_POINT_SMOOTH_HINT, GL_NICEST);
   
   
   for( unsigned int i=0;i<cities.size();i++)	
     {
	
	glPushMatrix();
	
	//camera->GlTransformBillBoard();
	
	glColor3f( 1.0f, 1.0f, 1.0f);
	glTranslatef( cities[i].position[0], cities[i].position[1], cities[i].position[2]);
	
	glRotatef( cities[i].longitude_deg,  0.0f, 1.0f,  0.0f); 
	glRotatef( cities[i].latitude_deg,  -1.0f,  0.0f,  0.0f); 
	
	glScaled( 0.00005f, 0.00005f, 0.00005f);
	
	font->Render( cities[i].name.c_str());
	
	glPopMatrix();
     }
   

   glLineWidth( 2.0f);
   flags_table->GlBind();
   glDisable( GL_BLEND);
	
   for( unsigned int i=0;i<cities.size();i++)	
     {

	if ( cities[i].is_capital)
	  { // Draw the drape
	     
	     glPushMatrix();
	     
	     glTranslatef( cities[i].position[0], cities[i].position[1], cities[i].position[2]);
	     
	     glRotatef( cities[i].longitude_deg,  0.0f, 1.0f,  0.0f); 
	     glRotatef( cities[i].latitude_deg,  -1.0f,  0.0f,  0.0f); 
	     
	     glColor3f( 0.0f, 0.0f, 0.0f);
	     glDisable( GL_TEXTURE_2D);
	     glBegin( GL_LINES);
	     glVertex3f( 0.0f, 0.0f, 0.0f);
	     glVertex3f( 0.0f, 0.005f, 0.0f);
	     glEnd();
	     glColor3f( 1.0f, 1.0f, 1.0f);
	     glEnable( GL_TEXTURE_2D);
	     glBegin( GL_QUADS);
	     flags_table->SetGlTexCoord( cities[i].flag_id, FlagsTable::UP_LEFT);
	     glVertex3f( 0.0f,   0.005f, 0.0f);
	     flags_table->SetGlTexCoord( cities[i].flag_id, FlagsTable::UP_RIGHT);
	     glVertex3f( 0.004f, 0.005f, 0.0f);
	     flags_table->SetGlTexCoord( cities[i].flag_id, FlagsTable::DOWN_RIGHT);
	     glVertex3f( 0.004f, 0.003f, 0.0f);
	     flags_table->SetGlTexCoord( cities[i].flag_id, FlagsTable::DOWN_LEFT);
	     glVertex3f( 0.0f,   0.003f, 0.0f);
	     glEnd();
	     glPopMatrix();
	  }
     }
/*
   for( unsigned int p=0 ; p < pof->size() ; p++)
     {     
       (*pof)[p]->Render();
     }

   glEnable( GL_BLEND);
   glBlendFunc( GL_SRC_ALPHA, GL_ONE);
   glEnable( GL_TEXTURE_2D);

   for( unsigned int p=0 ; p < pof->size() ; p++)
     {     
	
	glPushMatrix();
	
	//camera->GlTransformBillBoard();
	VO_Point *point = (VO_Point *) (*pof)[p]->GetVectObject();  
	
	glColor3f( 1.0f, 1.0f, 1.0f);
	glTranslatef( point->coord[0], point->coord[1], point->coord[2]);
	
	glRotatef( point->lon_deg,  0.0f, 1.0f,  0.0f); 
	glRotatef( point->lat_deg,  -1.0f,  0.0f,  0.0f); 
	
	glScaled( 0.00005f, 0.00005f, 0.00005f);
	
	string label = "unknown";
	(*pof)[p]->GetVectProperties()->HaveString( "label", &label);
	font2->Render( label.c_str());
	
	glPopMatrix();

     }
 */  
}

