#ifndef _CHUNK_HPP
#define _CHUNK_HPP

#include "Node.hpp"
#include "gl_stuff.hpp"

class Planet;
class Texture;
class BufferObject;
class VectInfoCollection;

struct Chunk
{
   Chunk();
   ~Chunk();
   
   void Load( Node node, Planet *mother_planet);

   void Draw();
   
   // informations
   Node node;
   Planet *mother_planet;
   bool children_preloaded;
   
   // data
   Texture *texture;
   BufferObject *bo;
   GLshort grid_width;
   GLshort *indices;
   GLshort nb_elements;
   
 private:
   class VectInfoCollection *vectorial_infos;
};

#endif /* _CHUNK_HPP */
