#include <string>
#include <stdlib.h>
#include <stdio.h>
#include "config.h"
#include "Options.hpp"
#include "Chunk.hpp"
#include "Texture.hpp"
#include "Planet.hpp"
#include "DataSet.hpp"
#include "BufferObject.hpp"
#include "VectInfos.hpp"

using namespace std;

Chunk::Chunk()
{
   texture = NULL;
   bo = NULL;
   indices = NULL;
   vectorial_infos = NULL;
   children_preloaded = false;
   mother_planet = NULL;
}

Chunk::~Chunk()
{
   if ( texture)
     delete texture;
   if ( bo)
     delete bo;
   if ( indices)
     delete[] indices;
   if ( vectorial_infos)
     delete vectorial_infos;
}

void Chunk::Load( Node node, Planet *mother_planet)
{
   try
     {
	
	char str[256];
	
	this->node = node;
	this->mother_planet = mother_planet;
	
	DataSet *ds = (DataSet *)mother_planet->GetDataSet();
	
	texture = new Texture();
   
#ifndef USE_TEXTURE_COMPRESSION
	
	if ( ds.isReady())
	  {  
	     sprintf( str,"%c/%04d.png", node.GetPrefix(), node.GetNumber());
	     texture->LoadImage( ds->OpenFile( str));	
	  }
	else
	  {
	     sprintf( str,"dataset/%c/%04d.png", node.GetPrefix(), node.GetNumber());
	     texture->LoadImage( str);
	  }
	
#else /* USE_TEXTURE_COMPRESSION is defined */
	
	if ( ds->isReady())
	  {
	     sprintf( str,"%c/%04d.ct", node.GetPrefix(), node.GetNumber());
	     texture->LoadCompressed( ds->OpenFile( str));
	  }
	else
	  {
	     sprintf( str,"dataset/%c/%04d.ct", node.GetPrefix(), node.GetNumber());
	     texture->LoadCompressed( str);
	     if ( !texture->IsReady())
	       cerr << "Chunk: can't load " << str << endl;
          }
   
#endif /* USE_TEXTURE_COMPRESSION defined */
		
	vectorial_infos = new VectInfoCollection();
	
	try
	  {	
	     
	     if ( ds->isReady())
	       {
		  sprintf( str,"%c/%04d.vnf", node.GetPrefix(), node.GetNumber());
		  SDL_RWops *r_ops = ds->OpenFile( str);
	     if ( r_ops == NULL )
		    throw string( "can't open file ") + str;
		  vectorial_infos->LoadBinary( r_ops);
		  SDL_RWclose( r_ops);
	  }
	     else
	       {
		  sprintf( str,"dataset/%c/%04d.vnf", node.GetPrefix(), node.GetNumber());
		  SDL_RWops *r_ops = SDL_RWFromFile( str, "rb");
	     if ( r_ops == NULL )
		    throw string( "can't open file ") + str;
		  vectorial_infos->LoadBinary( r_ops);
		  SDL_RWclose( r_ops);  
	       }
	  }
	catch(...)
	  {
	     fprintf( stderr, "Chunk: can't read vectorial data for node %d \n", node.GetNumber());
	  }
	
	mother_planet->FillChunkGeometry( this);
     }
   catch( string e)
     {
	cerr << "Failed to load chunk: " << e << endl;	
     }
   
}


void Chunk::Draw()
{

   bo->Bind();

   glEnable( GL_TEXTURE_2D);

   glIndexPointer( GL_SHORT, 0, indices);
   check_gl_error( "ChunkTree::DrawChunk glIndexPointer");

   glEnableClientState( GL_VERTEX_ARRAY);
   glEnableClientState( GL_NORMAL_ARRAY);
   glEnableClientState( GL_TEXTURE_COORD_ARRAY);
   check_gl_error( "ChunkTree::DrawChunk glEnableClientState");

   glColor4f( 1.0f, 1.0f, 1.0f, 1.0f);
   glDrawElements( GL_TRIANGLES, nb_elements, GL_UNSIGNED_SHORT, indices);
   glFlush();
   check_gl_error( "ChunkTree::DrawChunk glDrawElements");

   glDisableClientState( GL_VERTEX_ARRAY);
   glDisableClientState( GL_NORMAL_ARRAY);
   glDisableClientState( GL_TEXTURE_COORD_ARRAY);
   check_gl_error( "Chunk::Draw glDisableClientState");

   glDisable( GL_TEXTURE_2D);
   
   vectorial_infos->Render();
}
