#ifndef _CAMERA_HPP
#define _CAMERA_HPP

#include "math/Vector.hpp"
#include "frustum.hpp"

/** \file Camera.hpp
 * A class and associated methods to manage a simple Camera with OpenGL.
 */

/**
 * An implementatuion of a camera using OpenGL that permit to test if an object
 * is visible by this camera using a frustum.
 */

class Camera
{
   
 public:
   
   /** 
    * Default constructor 
    */
   Camera();

   /** 
    * Destructor
    */
   ~Camera();

   inline Vector3f GetEyePosition() { return eye_position;}
   inline void SetEyePosition( Vector3f eye_position) { this->eye_position = eye_position;}
   inline Vector3f GetLook() { return look;}
   inline void SetLook( Vector3f look) { this->look = look;}
   inline Vector3f GetUp() { return up;}
   inline void SetUp( Vector3f up) { this->up = up;}

   /**
    * 
    */
   
   void SetupProjectionMatrix( float fov_deg, float near, float far, unsigned width_pix, unsigned int height_pix);
   
   /**
    * Get the frustum relative to camera position & viewing direction
    * @return Frustum of the camera, in order to test visibility
    */
   inline Frustum* GetFrustum() { return &frustum;}
   
   /** 
    * Toggle compuation of frustum
    * @param use true to compute frustum, false to disable computing
    */
   inline void UseFrustum( const bool use) { use_frustum = use;}
   
   /**
    * Initilialize opengl matrix GL_MODELVIEW so as to view as defined
    * by current parameters of the camera
    */
   void GlTransform();

   void GlTransformBillBoard();
   
 private:
   
   // Projection
   float fov_deg;
   float nearest;
   float farest;
   unsigned int width_pix;
   unsigned int height_pix;
    
   // Transformations
   Vector3f eye_position;
   Vector3f look;
   Vector3f up;

   // Frustum Culling
   Frustum frustum;
   bool use_frustum;
};

#endif
