#include "Camera.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "gl_stuff.hpp"
#include <GL/glu.h>

Camera::Camera()
{
   use_frustum = true;
   eye_position = Vector3f( 0.0f, 0.0f, 0.0f);
   look = Vector3f( 0.0f, 0.0f, 0.0f);
   up = Vector3f( 0.0f, 1.0f, 0.0f);
}

Camera::~Camera()
{
}

void Camera::SetupProjectionMatrix( float fov_deg, float nearest, float farest, unsigned width_pix, unsigned int height_pix)
{
   this->fov_deg = fov_deg;
   this->nearest = nearest;
   this->farest = farest;
   this->width_pix = width_pix;
   this->height_pix = height_pix;

   glMatrixMode( GL_PROJECTION);
   glLoadIdentity();
   gluPerspective( fov_deg, ((float)width_pix)/((float)height_pix), nearest, farest);
}


void Camera::GlTransform()
{        
 
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
      
   gluLookAt( eye_position[0], eye_position[1], eye_position[2],
	      look[0], look[1], look[2],
	      up[0], up[1], up[2]);
      
   if ( use_frustum)
     frustum.extractFrustum();
}

void Camera::GlTransformBillBoard()
{
   float rot_x = 0.0f;
   float rot_y = 0.0f;
   
   glRotatef( -rot_y, 0.0f, -1.0f, 0.0f);
   glRotatef( -rot_x, 1.0f,  0.0f, 0.0f);
}
