#ifndef _CACHE_HPP
#define _CACHE_HPP

#include <SDL.h>
#include <SDL_thread.h>
#include <deque>
#include "Node.hpp"

using namespace std;

class Chunk;
class Planet;
class TextureArray;

struct ChunkEntry
{
   Node node;
   Chunk *chunk;
   unsigned int last_use;
   SDL_mutex *mutex;
};

//                                                                        //
// Class Cache:                                                           //
//                                                                        //
// The purpose of this class is to manage memory efficiently              //
//                                                                        //

class Cache
{
 public:
   Cache( unsigned int nb_entries);
   ~Cache();
   
   // Initialize Cache and start loading thread
   void Initialize( Planet *planet=NULL);
   
   // Get a chunk (locked)
   Chunk* GetChunk( Node node);
   
   // Unlock the chunk (must be called after each GetChunk) 
   void ReleaseChunk( Node node);
   void ReleaseChunk( Chunk* chunk);
   
   // Plan for loading
   void PlanChunkLoading( Node node);
   
 private:
   
   void LoadChunk( Node node);
   unsigned int GetFreeEntry();
   unsigned int LastRecentlyUsedEntry();
   void FreeEntry( unsigned int entry);
   void FreeAllEntries();
   bool NodeLoadedOrPlaned( Node node);
   
   deque< Node> nodes_planed_for_loading;
   bool *chunks_planed;
   ChunkEntry *entries;
   bool *buzzy_entries;
   unsigned int nb_entries;
   SDL_Thread *loading_thread;
   SDL_sem *sem_something_to_load; // used only by PlanNodeLoading and ManageChunks
   bool stop_loading_thread;
   SDL_mutex *mutex_queue;
   bool multi_thread;
   Planet *planet;
   TextureArray *texture_array;
 
 public:
   void Manage(); // TODO: should be private and load_thread a friend method
};

#endif
