#include <stdlib.h>
#include <stdio.h>
#include "BufferObject.hpp"
#include "gl_stuff.hpp"
#include "config.h"

#define GL_BUFFER_OFFSET(i)    ((char *)NULL + (i))

BufferObject::BufferObject( const unsigned long nb_vertices, const unsigned short vertex_size, const unsigned short normal_size, const unsigned short texcoord_size, const unsigned short color_size)
{
   this->nb_vertices = nb_vertices;
   this->vertex_size = vertex_size;
   this->normal_size = normal_size;
   this->texcoord_size = texcoord_size;
   this->color_size = color_size;
   
   normal_offset = vertex_size;
   texcoord_offset = normal_offset + normal_size;
   color_offset = texcoord_offset + texcoord_size;
   total_vertex_size = vertex_size + normal_size + texcoord_size + color_size; 

   buffer = new float[nb_vertices * total_vertex_size];

   buffer_uploaded = false;
   
#ifdef DEBUG_VERBOSE
   
   fprintf( stderr, "BufferObject: allocated buffer of %dKo\n", total_vertex_size*nb_vertices*4/1024);
   
#endif
   
}

BufferObject::~BufferObject()
{
   delete[] buffer;

#ifdef USE_VERTEX_BUFFER_OBJECT
   
   if ( buffer_uploaded)
     {
	gl_plan_destroying( OBJECT_GL_VERTEX_BUFFER_OBJECT, buffer_id);
     }
   
#endif

}

void BufferObject::Bind()
{
   
#ifdef USE_VERTEX_BUFFER_OBJECT
   
   // Check object_id validity
   
   if ( buffer_uploaded == false )
     {
	UpLoad();
     }
   
   if ( glIsBufferARB( buffer_id) == GL_FALSE)
     {
	fprintf( stderr, "BufferObject::Bind: %d is not a valid vertex_buffer_object\n", buffer_id); 
	return;
     }
   
   // Define arrays
   
   glBindBufferARB( GL_ARRAY_BUFFER_ARB, buffer_id);
   
   if ( check_gl_error( "ChunkTree::DrawChunk glBindBufferARGB"))
     {
	fprintf( stderr, "BufferObject::Bind: can't bind buffer %d\n", buffer_id);
	return;
     }
   
   if ( vertex_size != 0)
     {
	glVertexPointer( vertex_size, GL_FLOAT, total_vertex_size*sizeof(float), GL_BUFFER_OFFSET(0));
	check_gl_error( "BufferObject::Bind glVertexPointer");
     }
   
   if ( normal_size != 0)
     {
	glNormalPointer( GL_FLOAT, total_vertex_size*sizeof(float), GL_BUFFER_OFFSET( normal_offset*sizeof(float)));
	check_gl_error( "BufferObject::Bind glNormalPointer");
     }
   
   if ( texcoord_size != 0)
     {
//	glClientActiveTextureARB( GL_TEXTURE0_ARB);
	glTexCoordPointer( texcoord_size, GL_FLOAT, total_vertex_size*sizeof(float), GL_BUFFER_OFFSET( texcoord_offset*sizeof(float)));
	check_gl_error( "BufferObject::Bind glTexCoordPointer");

//	glClientActiveTextureARB( GL_TEXTURE0_ARB);
//	glTexCoordPointer( texcoord_size, GL_FLOAT, total_vertex_size*sizeof(float), GL_BUFFER_OFFSET( texcoord_offset*sizeof(float)));
//	check_gl_error( "BufferObject::Bind glTexCoordPointer");
     }
   
   if ( color_size != 0)
     {	
	glColorPointer( color_size, GL_FLOAT, total_vertex_size*sizeof(float), GL_BUFFER_OFFSET( color_offset*sizeof(float)));
	check_gl_error( "BufferObject::Bind glColorPointer");
     }
   
#else
   
   if ( vertex_size != 0 )
     {
	glVertexPointer( vertex_size, GL_FLOAT, total_vertex_size*sizeof(float), buffer);
	check_gl_error( "BufferObject::Bind glVertexPointer");
     }
   
   if ( normal_size != 0)
     {
	glNormalPointer( GL_FLOAT, total_vertex_size*sizeof(float), buffer+normal_offset);
	check_gl_error( "BufferObject::Bind glNormalPointer");
     }
   
   if ( texcoord_size != 0)
     {
	glTexCoordPointer( texcoord_size, GL_FLOAT, total_vertex_size*sizeof(float), buffer+texcoord_offset);
	check_gl_error( "BufferObject::Bind glTexCoordPointer");
     }
   
   if ( color_size != 0)
     {	
	glColorPointer( color_size, GL_FLOAT, total_vertex_size*sizeof(float), buffer+color_offset);
	check_gl_error( "BufferObject::Bind glColorPointer");
     }
   
#endif
   
}

void BufferObject::UnBind()
{
}

#ifdef USE_VERTEX_BUFFER_OBJECT

void BufferObject::UpLoad()
{
   // Get a fresh object_id
   
   glGenBuffersARB( 1, &buffer_id);
   
   // Create buffer object
   
   glBindBufferARB( GL_ARRAY_BUFFER_ARB, buffer_id);
   check_gl_error( "BufferObject::UpLoad: glBindBufferARB");
   
   // Initialize data to store buffer object
   
   glBufferDataARB( GL_ARRAY_BUFFER_ARB, nb_vertices*total_vertex_size*sizeof(float), buffer, GL_STATIC_DRAW_ARB);
   check_gl_error( "BufferObject::UpLoad: glBufferARB");
   
   if ( glIsBufferARB( buffer_id) == GL_TRUE)
     buffer_uploaded = true;
}

#endif
