#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include "world_for_SDL.h"
#include "main.h"

World_for_SDL::World_for_SDL() {
   
   back = NULL ;
   adversary = NULL ;
}

//-+---------- To Load a level from a file ----------------------------------+-
int World_for_SDL::LoadLevel( char* fileName) {
   ifstream levelFile ;
   char backName[256] ;
   char advName[256] ;
   char tmp[256] ;
   int i ;
   
   levelFile.open( fileName) ;
   levelFile >> backName ;
   levelFile >> advName ;
   back = VSDL_LoadPixmap( backName, 0, 0, 0) ;
   adversary = VSDL_LoadPixmap( advName, 1, 0, 0) ;
   
   for(i=0;i<NB_SFX;i++) {
      levelFile >> tmp ;
      sfx_pt[i] = VSDL_LoadSound( tmp) ;
   }
   return( 1) ;
}

/* The destructor */
World_for_SDL::~World_for_SDL() {
   
   VSDL_FreePixmap( adversary) ;
   VSDL_FreePixmap( back) ;
}

//-+---------- Display the entire World -------------------------------------+-
void World_for_SDL::Display() {
   VSDL_PutPixmap( back, 0, 0) ;
   VSDL_PutPixmap(adversary,280,255-80) ;
   int i ;
   
   
   /* Display the scores */
   VSDL_Print( 1, 1, fonts, "PLAYER 1") ;
   VSDL_Print( 480, 1, fonts, "PLAYER 2") ;
   for(i=0;i<score[1];i++)
     VSDL_Print( 20+20*i, 30, fonts, "|") ;
   for(i=0;i<score[2];i++)
     VSDL_Print( 620-20*(i+1), 30, fonts, "|") ;
    
   if ( ( noPlayer / nbPlayers ) == 0 ) /* what team: front or back ? */
     VSDL_soft3d_SetCamera( 600, 265, -3.14/2, +3.14/2 ,320 ,200) ;
   else
     VSDL_soft3d_SetCamera( 600, 265, +3.14/2, -3.14/2, 320, 200) ;
   
   /* Display the Players */
   for(i=1;i<=nbPlayers;i++) {
      int pX, pY, pZ ;
      
      pX = (short)R[i]->posX - RK_WIDTH/2 ;
      pY = (short)R[i]->posY ;
      pZ = (short)R[i]->posZ - RK_DEEP/2 ;
      
      /* This is the right */
      VSDL_soft3d_SetColor( 150, 0 , 0) ;
      VSDL_soft3d_PutTriangle(pX,pY,pZ, pX,pY-RK_HEIGHT,pZ, pX,pY-RK_HEIGHT,pZ+RK_DEEP) ;
      VSDL_soft3d_PutTriangle(pX,pY,pZ+RK_DEEP, pX,pY-RK_HEIGHT,pZ+RK_DEEP, pX,pY,pZ) ;
      
      /* This is the left */
      VSDL_soft3d_PutTriangle(pX+RK_WIDTH,pY,pZ, pX+RK_WIDTH,pY-RK_HEIGHT,pZ, pX+RK_WIDTH,pY-RK_HEIGHT,pZ+RK_DEEP) ;
      VSDL_soft3d_PutTriangle(pX+RK_WIDTH,pY,pZ+RK_DEEP, pX+RK_WIDTH,pY-RK_HEIGHT,pZ+RK_DEEP, pX+RK_WIDTH,pY,pZ) ;
      
      /* This is the top */
      VSDL_soft3d_SetColor( 255, 0 , 0) ;
      VSDL_soft3d_PutTriangle(pX,pY-RK_HEIGHT,pZ, pX+RK_WIDTH,pY-RK_HEIGHT,pZ, pX+RK_WIDTH,pY-RK_HEIGHT,pZ+RK_DEEP) ;
      VSDL_soft3d_PutTriangle(pX,pY-RK_HEIGHT,pZ, pX,pY-RK_HEIGHT,pZ+RK_DEEP, pX+RK_WIDTH,pY-RK_HEIGHT,pZ+RK_DEEP) ;
      
      /* This is the back */
      VSDL_soft3d_SetColor( 200, 0, 0) ;
      VSDL_soft3d_PutTriangle(pX,pY,pZ+RK_DEEP, pX+RK_WIDTH,pY,pZ+RK_DEEP, pX+RK_WIDTH,pY-RK_HEIGHT,pZ+RK_DEEP) ;
      VSDL_soft3d_PutTriangle(pX,pY-RK_HEIGHT,pZ+RK_DEEP, pX+RK_WIDTH,pY-RK_HEIGHT,pZ+RK_DEEP, pX,pY,pZ+RK_DEEP) ;
      
      /* And yhis is the front */
      VSDL_soft3d_SetColor( 200, 0 , 0) ;
      VSDL_soft3d_PutTriangle(pX,pY,pZ, pX+RK_WIDTH,pY,pZ, pX+RK_WIDTH,pY-RK_HEIGHT,pZ) ;
      VSDL_soft3d_PutTriangle(pX,pY-RK_HEIGHT,pZ, pX+RK_WIDTH,pY-RK_HEIGHT,pZ, pX,pY,pZ) ;
   }
   /* And the Ball */
   VSDL_soft3d_SetColor( 255, 255 , 255) ;
     {
	double a ;
	float posX = B->posX , posY = B->posY , posZ = B->posZ ;
	for (a=0;a<=6.4;a=a+0.4) { ;
	   VSDL_soft3d_PutTriangle((short)(posX+10*cos(a)),(short)posY-BALL_HEIGHT,(short)(posZ+10*sin(a)),
				   (short)(posX+10*cos(a+0.4)),(short)posY-BALL_HEIGHT,(short)(posZ+10*sin(a+0.4)),
				   (short)(posX+10*cos(a)),(short)posY,(short)(posZ+10*sin(a))) ;
	   VSDL_soft3d_PutTriangle((short)(posX+10*cos(a)),(short)posY,(short)(posZ+10*sin(a)),
				   (short)(posX+10*cos(a+0.4)),(short)posY,(short)(posZ+10*sin(a+0.4)),
				   (short)(posX+10*cos(a+0.4)),(short)posY-BALL_HEIGHT,(short)(posZ+10*sin(a+0.4))) ;
	}
	for (a=0;a<=6.4;a=a+0.4) {
	   VSDL_soft3d_PutTriangle((short)posX,(short)posY-BALL_HEIGHT,(short)posZ,
				   (short)(posX+10*cos(a)),(short)posY-BALL_HEIGHT,(short)(posZ+10*sin(a)),
				   (short)(posX+10*cos(a+0.4)),(short)posY-BALL_HEIGHT,(short)(posZ+10*sin(a+0.4))) ;
	}
     }
   VSDL_soft3d_Render() ;
   if ( state == WORLD_STATE_SERVICE) {
      char tmp[256] ;
      sprintf( tmp, "SERVICE TO PLAYER %d", service) ;
      VSDL_Print( 100, 80, fonts, tmp) ;
   }
   
   for(i=0;i<NB_SFX;i++) {
      if ( sfx[i] > 0 ) {
	 VSDL_PlaySound( sfx_pt[i]) ;
	 sfx[i] = 0 ;
      }  
   }
}
